
<script>

    function change_visibility(model, sno, encrypted_id) {
        $("#visibility_error"+sno).html("");
        if(sno == "" || sno == 0 || sno == undefined || sno == null) {
            $("#visibility_error"+sno).html("Visibility is required!");
            return false;
        }

        let token = '<?php echo e(csrf_token()); ?>';
        let visibility = $("#visibility"+sno).val();
        $("#visibility" + sno).attr('disabled', true);
        $.ajax({
            url: "<?php echo e(route('change.visibility')); ?>",
            data: {'_token': token, 'model': model, 'visibility': visibility, 'encrypted_id': encrypted_id},
            type: "POST",
            dataType: 'json',
            success: function(result) {
                if(result.status == 'done') {
                    Swal.fire({
                        icon: "success",
                        title: result.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    setTimeout(function() {
                        $("#visibility" + sno).attr('disabled', false);
                    }, 1500);
                }
                else {
                    Swal.fire({
                        icon: "error",
                        title: result.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                }
            }
        });
    }

    function change_status(model, sno, encrypted_id) {
        let token = '<?php echo e(csrf_token()); ?>';
        $("#status" + sno).attr('disabled', true);
        $.ajax({
            url: "<?php echo e(route('change.status')); ?>",
            data: {'_token': token, 'model': model, 'encrypted_id': encrypted_id},
            type: "POST",
            dataType: 'json',
            success: function(result) {
                if(result.status == 'done') {
                    Swal.fire({
                        icon: "success",
                        title: result.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                    setTimeout(function() {
                        $("#status" + sno).attr('disabled', false);
                    }, 1500);
                }
                else {
                    Swal.fire({
                        icon: "error",
                        title: result.message,
                        showConfirmButton: false,
                        timer: 1500
                    });
                }
            }
        });
    }

    function delete_item(model, encrypted_id) {
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: "btn btn-success ms-2",
                cancelButton: "btn btn-danger"
            },
            buttonsStyling: false
        });

        swalWithBootstrapButtons.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonText: "Yes, Delete it!",
            cancelButtonText: "No, Cancel!",
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                let token = '<?php echo e(csrf_token()); ?>';
                $.ajax({
                    url: "<?php echo e(route('delete.item')); ?>",
                    data: {'_token': token, 'model': model, 'encrypted_id': encrypted_id},
                    type: "POST",
                    success: function(result) {
                        if(result.status == 'done') {
                            swalWithBootstrapButtons.fire({
                                title: result.title,
                                text: result.message,
                                icon: "success",
                                showConfirmButton: false,
                                timer: 1500
                            });
                            setTimeout(function() {
                                window.location.reload();
                            }, 1500);
                        }
                        else {
                            swalWithBootstrapButtons.fire({
                                title: result.title,
                                text: result.message,
                                icon: "error",
                                showConfirmButton: false,
                                timer: 1500
                            });
                        }
                    }
                });
            }
            else if (
                result.dismiss === Swal.DismissReason.cancel
            ) {
                swalWithBootstrapButtons.fire({
                title: "Cancelled",
                text: "Your data is safe :)",
                icon: "error",
                showConfirmButton: false,
                timer: 1500
                });
            }
        });
    }

</script>
<?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/ajax/operations.blade.php ENDPATH**/ ?>