
<?php if(!empty($plan->encrypted_id)) {
    $title = "Edit Plan";
} else {
    $title = "Add Plan";
}
?>
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($plan->encrypted_id) ? route('edit.plan', $plan->encrypted_id) : route('add.plan')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="<?php echo e(route('manage.plans')); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="plan_name" class="col-form-label">Plan Name</label>
                                    <input type="text" class="form-control" id="plan_name" name="plan_name" value="<?php echo e(!empty($plan->encrypted_id) ? $plan->plan_name : ''); ?>" placeholder="Enter Name" />
                                    <?php $__errorArgs = ['plan_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="plan_price" class="col-form-label">Plan Price</label>
                                    <input type="text" class="form-control" id="plan_price" name="plan_price" value="<?php echo e(!empty($plan->encrypted_id) ? $plan->plan_price : ''); ?>" placeholder="Enter Price" />
                                    <?php $__errorArgs = ['plan_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="plan_price_base" class="form-label">Plan per Base</label>
                                    <select name="plan_price_base" id="plan_price_base" class="form-select">
                                        <?php if(!empty($plan->encrypted_id)): ?>
                                        <option value="month" <?php echo e($plan->plan_price_base == 'month' ? "selected" : ""); ?>>Monthly</option>
                                        <option value="year" <?php echo e($plan->plan_price_base == 'year' ? "selected" : ""); ?>>Yearly</option>
                                        <?php else: ?>
                                        <option value="" selected>-- Select Price Base --</option>
                                        <option value="month">Monthly</option>
                                        <option value="year">Yearly</option>
                                        <?php endif; ?>
                                    </select>
                                    <?php $__errorArgs = ['plan_price_base'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="plan_category" class="form-label">Plan Category</label>
                                    <select name="plan_category" id="plan_category" class="form-select">
                                        <?php if(!empty($plan->encrypted_id)): ?>
                                        <option value="popular" <?php echo e($plan->plan_category == 'popular' ? "selected" : ""); ?>>Popular</option>
                                        
                                        <?php else: ?>
                                        <option value="" selected>-- Select Category --</option>
                                        <option value="popular">Popular</option>
                                        
                                        <?php endif; ?>
                                    </select>
                                    <?php $__errorArgs = ['plan_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-12">
                                    <label for="short_description" class="col-form-label">Short Description</label>
                                    <textarea name="short_description" id="short_description" cols="30" rows="5" class="form-control" placeholder="Enter Description" ><?php echo e(!empty($plan->encrypted_id) ? htmlspecialchars_decode($plan->short_description) : ''); ?></textarea>
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" ><?php echo e(!empty($plan->encrypted_id) ? htmlspecialchars_decode($plan->description) : ''); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="plan_image" class="col-form-label">Plan Image</label>
                                <?php if(!empty($plan->encrypted_id) && !empty($plan->plan_image)): ?>
                                <div class="my-3">
                                    <img src="<?php echo e(asset($plan->plan_image)); ?>" alt="Feature_Image" class="rounded" height="50px" width="50px">
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="plan_image" name="plan_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($plan->encrypted_id) ? "Update Plan" : "Add Plan"); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('manage.plans')); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mateluas/wavedisk/wavedisk-api/laravel-api/resources/views/admin/plan-ops.blade.php ENDPATH**/ ?>