<?php
    if (isset($customer)) {
        $title = 'Manage Modules Data regarding ' . $customer->first_name . ' ' . $customer->last_name;
    } else {
        $title = 'Manage Modules Data';
    }
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header"><?php echo e($title); ?>

                    <?php if(isset($customer)): ?>
                        <span class="float-end">
                            <a href="<?php echo e(route('get.all.customers')); ?>"
                                class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i
                                    class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                        </span>
                    <?php endif; ?>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Module Status</th>
                                <th>Link Validity</th>
                                <th>Expiration Date</th>
                                <th>Total Clicks</th>
                                <th>Receiver E-Mail</th>
                                <?php if(!isset($customer)): ?>
                                    <th>Sender E-Mail</th>
                                <?php endif; ?>
                                
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            <?php $__currentLoopData = $modulesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $modules): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        <?php if($modules->is_valid == 'Invalid'): ?>
                                            <strong class="text-danger">Expired</strong>
                                        <?php else: ?>
                                            <strong class="text-success">Active</strong>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($modules->is_valid == 'Invalid'): ?>
                                            <strong class="text-danger">Invalid</strong>
                                        <?php else: ?>
                                            <strong class="text-success">Valid</strong>
                                        <?php endif; ?>
                                    </td>
                                    <td><strong><?php echo e(date('h:i A, M d, Y', strtotime($modules->validity))); ?></strong></td>
                                    <td><strong><?php echo e($modules->total_clicks); ?></strong></td>
                                    <td><?php echo e($modules->email_to); ?></td>
                                    <?php if(!isset($customer)): ?>
                                        <td><?php echo e($modules->your_email); ?></td>
                                    <?php endif; ?>
                                    
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <?php if(isset($customer)): ?>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('view.files', ['customer_enc' => $customer->encrypted_id, 'module_id' => $modules->encrypted_id])); ?>">
                                                        <i class="bx bx-show me-1"></i> View Files Data
                                                    </a>
                                                <?php else: ?>
                                                    <a class="dropdown-item"
                                                        href="<?php echo e(route('view.files', $modules->encrypted_id)); ?>">
                                                        <i class="bx bx-show me-1"></i> View Files
                                                    </a>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $("#table").DataTable();
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/manage_users_data.blade.php ENDPATH**/ ?>