<?php if(!empty($subsection->encrypted_id)) {
    $title = "Edit Page Sub-Section";
} else {
    $title = "Add Page Sub-Section";
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($subsection->encrypted_id) ? route('edit.page.subsection', ["page" => $page_enc_id, "section" => $section_enc_id, "subsection" => $subsection->encrypted_id]) : route('add.page.subsection', ["page" => $page_enc_id, "section" => $section_enc_id])); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="<?php echo e(route('edit.page.section', ["page" => $page_enc_id, "section" => $section_enc_id])); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <?php if(session()->get('role') == 'superadmin'): ?>
                                <div class="col-6">
                                    <label for="default_subsection_name" class="col-form-label">Default Section Name</label>
                                    <input type="text" class="form-control" id="default_subsection_name" name="default_subsection_name" value="<?php echo e(!empty($subsection->encrypted_id) ? $subsection->default_section_name : ''); ?>" placeholder="Enter Default Name" />
                                </div>
                                <?php endif; ?>
                                <div class="col-6">
                                    <label for="subsection_title" class="col-form-label">Sub-Section Title</label>
                                    <input type="text" class="form-control" id="subsection_title" name="subsection_title" value="<?php echo e(!empty($subsection->encrypted_id) ? $subsection->section_title : ''); ?>" placeholder="Enter Title" />
                                </div>
                                <div class="col-6">
                                    <label for="subsection_headline" class="col-form-label">Sub-Section Headline</label>
                                    <input type="text" class="form-control" id="subsection_headline" name="subsection_headline" value="<?php echo e(!empty($subsection->encrypted_id) ? $subsection->section_headline : ''); ?>" placeholder="Enter Headline" />
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" ><?php echo e(!empty($subsection->encrypted_id) ? htmlspecialchars_decode($subsection->description) : ''); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card mb-3">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="subsection_image" class="col-form-label">Sub-Section Image</label>
                                <?php if(!empty($subsection->encrypted_id) && !empty($subsection->section_image)): ?>
                                <div class="my-3">
                                    <img src="<?php echo e(asset($subsection->section_image)); ?>" alt="Sub_Section_Image" class="rounded" height="50px" width="50px">
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="subsection_image" name="subsection_image" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($subsection->encrypted_id) ? 'Update Sub-Section' : 'Add Sub-Section'); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('edit.page.section', ["page" => $page_enc_id, "section" => $section_enc_id])); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mateluas/wavedisk/wavedisk-api/laravel-api/resources/views/admin/page-subsection-ops.blade.php ENDPATH**/ ?>