<?php $__env->startSection('title', 'Manage Assignments'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Assignments
                    <span class="float-end">
                        <a href="<?php echo e(route('add.assignment', $courseId)); ?>"
                            class="btn rounded-pill btn-icon btn-outline-primary float-end ms-2"
                            style="font-size: 1.7em;">+</a>
                        <a href="<?php echo e(route('manage.courses')); ?>"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end">
                            <i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i>
                        </a>
                    </span>
                </h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Assignment Code</th>
                                <th>Assignment Title</th>
                                <th>Assignment Position</th>
                                <th>Assignment Image</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            <?php $__currentLoopData = $assignmentsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td><strong><?php echo e($assignment->assignment_code); ?></strong></td>
                                    <td><?php echo e($assignment->assignment_title); ?></td>
                                    <td><?php echo e($assignment->position_order); ?></td>
                                    <td>
                                        <?php if(!empty($assignment->assignment_image)): ?>
                                            <i class="fa-solid <?php echo e($assignment->assignment_image); ?>"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input status_button"
                                                onclick="change_status('<?= $model ?>', <?= $sno ?>, '<?= $assignment->encrypted_id ?>');"
                                                type="checkbox" id="status<?= $sno ?>"
                                                <?= $assignment->status == 'active' ? 'checked' : '' ?> />
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('edit.assignment', ['course' => $courseId, 'assignment' => $assignment->encrypted_id])); ?>">
                                                    <i class="bx bx-edit-alt me-1"></i> Edit
                                                </a>
                                                <button class="dropdown-item"
                                                    onclick="delete_item('<?= $model ?>', '<?= $assignment->encrypted_id ?>');">
                                                    <i class="bx bx-trash me-1"></i> Delete
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $("#table").DataTable();

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\excelsius-ignou-api\resources\views/admin/manage_assignments.blade.php ENDPATH**/ ?>