<?php if(!empty($testimonial->encrypted_id)) {
    $title = "Edit Testimonial";
} else {
    $title = "Add Testimonial";
}
?>
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($testimonial->encrypted_id) ? route('edit.testimonial', $testimonial->encrypted_id) : route('add.testimonial')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="<?php echo e(route('manage.testimonials')); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="client_name" class="col-form-label">Client Name</label>
                                    <input type="text" class="form-control" id="client_name" name="client_name" value="<?php echo e(!empty($testimonial->encrypted_id) ? $testimonial->client_name : ''); ?>" placeholder="Enter Name" />
                                    <?php $__errorArgs = ['client_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-6">
                                    <label for="review_date" class="col-form-label">Client Review Date</label>
                                    <input type="date" class="form-control" id="review_date" name="review_date" value="<?php echo e(!empty($testimonial->encrypted_id) ? date("Y-m-d", strtotime($testimonial->review_date)) : ''); ?>" placeholder="Select Date" />
                                </div>
                                <div class="col-6">
                                    <label for="rating_quantity" class="col-form-label">Client Rating</label>
                                    <input type="text" class="form-control" id="rating_quantity" name="rating_quantity" value="<?php echo e(!empty($testimonial->encrypted_id) ? $testimonial->rating_quantity : ''); ?>" placeholder="Enter Rating Quantity" />
                                    <?php $__errorArgs = ['rating_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" ><?php echo e(!empty($testimonial->encrypted_id) ? htmlspecialchars_decode($testimonial->description) : ''); ?></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="client_image" class="col-form-label">Client Image</label>
                                <?php if(!empty($testimonial->encrypted_id) && !empty($testimonial->client_image)): ?>
                                <div class="my-3">
                                    <img src="<?php echo e(asset($testimonial->client_image)); ?>" alt="Client_Image" class="rounded" height="50px" width="50px">
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="client_image" name="client_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($testimonial->encrypted_id) ? "Update Testimonial" : "Add Testimonial"); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('manage.testimonials')); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mateluas/wavedisk/wavedisk-api/laravel-api/resources/views/admin/testimonial-ops.blade.php ENDPATH**/ ?>