<?php if(!empty($partner->encrypted_id)) {
    $title = "Edit Partner";
} else {
    $title = "Add Partner";
}
?>
<?php $__env->startSection('title', $title); ?>
<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($partner->encrypted_id) ? route('edit.partner', $partner->encrypted_id) : route('add.partner')); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="<?php echo e(route('manage.partners')); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <?php if(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="partner_name" class="col-form-label">Partner Name</label>
                                    <input type="text" class="form-control" id="partner_name" name="partner_name" value="<?php echo e(!empty($partner->encrypted_id) ? $partner->partner_name : ''); ?>" placeholder="Enter Name" />
                                    <?php $__errorArgs = ['partner_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="partner_image" class="col-form-label">Partner Image</label>
                                <?php if(!empty($partner->encrypted_id) && !empty($partner->partner_image)): ?>
                                <div class="my-3">
                                    <img src="<?php echo e(asset($partner->partner_image)); ?>" alt="Partner_Image" class="rounded" height="50px" width="50px">
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="partner_image" name="partner_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($partner->encrypted_id) ? "Update Partner" : "Add Partner"); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('manage.partners')); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laravel_projects\wave-disk-api\resources\views/admin/partner-ops.blade.php ENDPATH**/ ?>