<div class="col-md-6 col-lg-4 order-2 mb-4">
    <div class="card h-100">
        <div class="card-header d-flex align-items-center justify-content-between">
            <h5 class="card-title m-0 me-2">Plan Transactions</h5>
            <div class="dropdown">
                <button class="btn p-0" type="button" id="transactionMenu" data-bs-toggle="dropdown" aria-haspopup="true"
                    aria-expanded="false">
                    <i class="bx bx-dots-vertical-rounded"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-end" aria-labelledby="transactionMenu">
                    <a class="dropdown-item" href="javascript:void(0);">Last 30 Days</a>
                    <a class="dropdown-item" href="javascript:void(0);">Last 3 Months</a>
                    <a class="dropdown-item" href="javascript:void(0);">Last Year</a>
                </div>
            </div>
        </div>

        <div class="card-body">
            <ul class="p-0 m-0" id="transactionsList">
                <li class="text-center py-3 text-muted">Loading...</li>
            </ul>
            
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        const $list = $('#transactionsList');

        function loadTransactions(filter = 'thirty_days') {
            $list.html('<li class="text-center py-3 text-muted">Loading...</li>');

            $.ajax({
                url: "<?php echo e(route('transactions.data')); ?>",
                method: "GET",
                data: {
                    filter
                },
                dataType: "json",
                success: function(response) {
                    const transactions = response.transactions;

                    if (!transactions.length) {
                        $list.html(
                            '<li class="text-center py-3 text-muted">No transactions found</li>'
                        );
                        return;
                    }

                    const icons = {
                        purchase: 'bx-check-circle bg-label-success',
                        renewal: 'bx-refresh bg-label-primary',
                        upgrade: 'bx-up-arrow-circle bg-label-info',
                        refund: 'bx-undo bg-label-warning',
                        failed: 'bx-error-circle bg-label-danger'
                    };

                    const html = transactions.map(t => `
                    <li class="d-flex mb-4 pb-1">
                        <div class="avatar flex-shrink-0 me-3">
                            <span class="avatar-initial rounded ${icons[t.type] || 'bg-label-secondary'}">
                                <i class="bx ${icons[t.type]?.split(' ')[0] || 'bx-file'}"></i>
                            </span>
                        </div>
                        <div class="d-flex w-100 flex-wrap align-items-center justify-content-between gap-2">
                            <div class="me-2">
                                <small class="text-muted d-block mb-1">${t.platform}</small>
                                <h6 class="mb-0">${t.title}</h6>
                            </div>
                            <div class="user-progress d-flex align-items-center gap-1">
                                <h6 class="mb-0 ${t.status === 'refund' || t.status === 'failed' ? 'text-danger' : ''}">
                                    ${t.status === 'refund' || t.status === 'failed' ? '-' : '+'}${t.amount}
                                </h6>
                                <span class="text-muted">${t.currency}</span>
                            </div>
                        </div>
                    </li>
                `).join('');

                    $list.html(html);
                },
                error: function() {
                    $list.html(
                        '<li class="text-center py-3 text-danger">Failed to load transactions</li>'
                    );
                }
            });
        }

        // Load default (Last 30 Days)
        loadTransactions();

        // Dropdown filters
        $('.dropdown-item').on('click', function() {
            const text = $(this).text().trim();
            let filter = 'thirty_days';
            if (text.includes('3 Months')) filter = 'three_months';
            if (text.includes('Year')) filter = 'year';
            loadTransactions(filter);
        });
    });
</script>
<?php /**PATH D:\excelsius-ignou-api\resources\views/admin/components/plan-transactions.blade.php ENDPATH**/ ?>