<?php $__env->startSection('title', 'Manage Courses'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php elseif(session('error')): ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e(session('error')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
            <!-- Hoverable Table rows -->
            <div class="card">
                <h5 class="card-header">Manage Courses<a href="<?php echo e(route('add.course')); ?>"
                        class="btn rounded-pill btn-icon btn-outline-primary float-end"
                        style="font-size: 1.7em;">+</span></a></h5>
                <div class="table-responsive text-nowrap px-4 pb-4">
                    <table id="table" class="table table-hover">
                        <thead>
                            <tr>
                                <th>S. No.</th>
                                <th>Manage Assignments</th>
                                <th>Course Code</th>
                                <th>Course Name</th>
                                <th>Course Headline</th>
                                <th>Course Position</th>
                                <th>Course Icon</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="table-border-bottom-0">
                            <?php $sno = 1; ?>
                            <?php $__currentLoopData = $coursesData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?= $sno ?>.</td>
                                    <td>
                                        <a class="btn btn-sm btn-primary"
                                            href="<?php echo e(route('manage.assignments', $course->encrypted_id)); ?>">
                                            <i class="bx bx-file me-1"></i> Assignments
                                        </a>
                                        
                                    </td>
                                    <td><strong><?php echo e($course->course_code); ?></strong></td>
                                    <td><?php echo e($course->course_name); ?></td>
                                    <td><?php echo e($course->course_headline); ?></td>
                                    <td><?php echo e($course->position_order); ?></td>
                                    <td>
                                        <?php if(!empty($course->course_icon)): ?>
                                            <i class="fa-solid <?php echo e($course->course_icon); ?>"></i>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="form-check form-switch mb-2">
                                            <input class="form-check-input status_button"
                                                onclick="change_status('<?= $model ?>', <?= $sno ?>, '<?= $course->encrypted_id ?>');"
                                                type="checkbox" id="status<?= $sno ?>"
                                                <?= $course->status == 'active' ? 'checked' : '' ?> />
                                        </div>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow"
                                                data-bs-toggle="dropdown">
                                                <i class="bx bx-dots-vertical-rounded"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item"
                                                    href="<?php echo e(route('edit.course', $course->encrypted_id)); ?>">
                                                    <i class="bx bx-edit-alt me-1"></i> Edit
                                                </a>
                                                <button class="dropdown-item"
                                                    onclick="delete_item('<?= $model ?>', '<?= $course->encrypted_id ?>');">
                                                    <i class="bx bx-trash me-1"></i> Delete
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php $sno++; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
    <script>
        $("#table").DataTable();

        
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\excelsius-ignou-api\resources\views/admin/manage_courses.blade.php ENDPATH**/ ?>