<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Customer Plan Invoice</title>
</head>

<body>
    <p>Hello <?php echo e($invoice->customer->first_name . ' ' . $invoice->customer->last_name); ?>,</p>

    <p>Your payment has been successfully processed. Please find your invoice attached.</p>

    <ul>
        <li><strong>Invoice Number:</strong> <?php echo e($invoice->invoice_number); ?></li>
        <li><strong>Amount:</strong> ₹<?php echo e(number_format($invoice->amount, 2)); ?></li>
        <li><strong>Status:</strong> <?php echo e(ucfirst($invoice->status)); ?></li>
        <li><strong>Date:</strong> <?php echo e($invoice->created_at->format('d M Y H:i')); ?></li>
    </ul>

    <p>You can also download your invoice here: <a href="<?php echo e($downloadLink); ?>"><?php echo e($downloadLink); ?></a></p>

    <p>Thanks,<br><?php echo e(env('INVOICE_MAIL_NAME')); ?></p>
</body>

</html>
<?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/emails/invoice.blade.php ENDPATH**/ ?>