
<?php $__env->startSection('title', 'Change Password'); ?>

<?php $__env->startSection('content'); ?>

    <div class="content-wrapper">
        <div class="container-xxl flex-grow-1 container-p-y">

            <div class="authentication-wrapper authentication-basic container-p-y">
                <div class="authentication-inner">

                    <?php if(session('error')): ?>
                        <div class="alert alert-danger alert-dismissible" role="alert">
                            <?php echo e(session('error')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <div class="card">
                        <div class="card-body">

                            <form id="password_form" action="<?php echo e(route('change.password')); ?>" method="POST"
                                onsubmit="return validatePasswordForm();">
                                <?php echo csrf_field(); ?>

                                <div class="mb-3 form-password-toggle">
                                    <label class="form-label" for="old_pwd">Old Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="old_pwd" name="old_pwd" class="form-control"
                                            placeholder="Enter Old Password">
                                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    </div>
                                    <div id="old_pwd_error" class="text-danger"></div>
                                    <?php $__errorArgs = ['old_pwd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 form-password-toggle">
                                    <label class="form-label" for="new_pwd">New Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="new_pwd" name="new_pwd" class="form-control"
                                            placeholder="Enter New Password">
                                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    </div>
                                    <div id="new_pwd_error" class="text-danger"></div>
                                    <?php $__errorArgs = ['new_pwd'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3 form-password-toggle">
                                    <label class="form-label" for="new_pwd_confirmation">Confirm New Password</label>
                                    <div class="input-group input-group-merge">
                                        <input type="password" id="new_pwd_confirmation" name="new_pwd_confirmation"
                                            class="form-control" placeholder="Confirm New Password">
                                        <span class="input-group-text cursor-pointer"><i class="bx bx-hide"></i></span>
                                    </div>
                                    <div id="confirm_pwd_error" class="text-danger"></div>
                                    <?php $__errorArgs = ['new_pwd_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="text-danger"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                                <div class="mb-3">
                                    <button
                                        class="btn btn-primary d-grid w-100 d-flex justify-content-center align-items-center gap-2"
                                        id="updatePasswordBtn" type="submit">
                                        <span id="btnText">Update Password</span>
                                        <span id="btnLoader" class="spinner-border spinner-border-sm d-none" role="status"
                                            aria-hidden="true"></span>
                                    </button>

                                </div>
                            </form>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>


    <script>
        function validatePasswordForm() {
            let errors = 0;

            let oldPwd = $("#old_pwd").val().trim();
            let newPwd = $("#new_pwd").val().trim();
            let confirmPwd = $("#new_pwd_confirmation").val().trim();

            // Old password validation
            if (oldPwd === "") {
                $("#old_pwd_error").text("Old password is required.");
                errors++;
            } else {
                $("#old_pwd_error").text("");
            }

            // New password validation
            if (newPwd === "") {
                $("#new_pwd_error").text("New password is required.");
                errors++;
            } else {
                $("#new_pwd_error").text("");
            }

            // Confirm password validation
            if (confirmPwd === "") {
                $("#confirm_pwd_error").text("Confirm password is required.");
                errors++;
            } else if (confirmPwd !== newPwd) {
                $("#confirm_pwd_error").text("Passwords do not match.");
                errors++;
            } else {
                $("#confirm_pwd_error").text("");
            }

            if (errors > 0) {
                return false;
            } else {
                document.getElementById("btnText").textContent = "Please Wait...";
                document.getElementById("btnLoader").classList.remove("d-none");
                document.getElementById("updatePasswordBtn").disabled = true;
            }
        }
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/change-password.blade.php ENDPATH**/ ?>