<?php if(!empty($section->encrypted_id)) {
    $title = "Edit Page Section & Page Sub-Section Management";
} else {
    $title = "Add Page Section";
}
?>
<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="<?php echo e(!empty($section->encrypted_id) ? route('edit.page.section', ["page" => $page_enc_id, "section" => $section->encrypted_id]) : route('add.page.section', $page_enc_id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="<?php echo e(route('edit.page', $page_enc_id)); ?>" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible" role="alert">
                        <?php echo e(session('success')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php elseif(session('error')): ?>
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        <?php echo e(session('error')); ?>

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    <?php endif; ?>
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <?php if(session()->get('role') == 'superadmin'): ?>
                                <div class="col-6">
                                    <label for="default_section_name" class="col-form-label">Default Section Name</label>
                                    <input type="text" class="form-control" id="default_section_name" name="default_section_name" value="<?php echo e(!empty($section->encrypted_id) ? $section->default_section_name : ''); ?>" placeholder="Enter Default Name" />
                                </div>
                                <?php endif; ?>
                                <div class="col-6">
                                    <label for="section_title" class="col-form-label">Section Title</label>
                                    <input type="text" class="form-control" id="section_title" name="section_title" value="<?php echo e(!empty($section->encrypted_id) ? $section->section_title : ''); ?>" placeholder="Enter Title" />
                                </div>
                                <div class="col-6">
                                    <label for="section_headline" class="col-form-label">Section Headline</label>
                                    <input type="text" class="form-control" id="section_headline" name="section_headline" value="<?php echo e(!empty($section->encrypted_id) ? $section->section_headline : ''); ?>" placeholder="Enter Headline" />
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" ><?php echo e(!empty($section->encrypted_id) ? htmlspecialchars_decode($section->description) : ''); ?></textarea>
                                </div>
                                <div class="col-12">
                                    <label for="button_name" class="col-form-label">Button</label>
                                    <div class="row">
                                        <div class="col-6">
                                            <input type="text" class="form-control" id="button_name" name="button_name" value="<?php echo e(!empty($section->encrypted_id) ? $section->button_name : ''); ?>" placeholder="Enter Name" />
                                        </div>
                                        <?php if(session()->get('role') == 'superadmin'): ?>
                                        <div class="col-6">
                                            <input type="text" class="form-control" id="button_link" name="button_link" value="<?php echo e(!empty($section->encrypted_id) ? $section->button_link : ''); ?>" placeholder="Enter Link" />
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-6">
                                <label for="section_image" class="col-form-label">Section Image</label>
                                <?php if(!empty($section->encrypted_id) && !empty($section->section_image)): ?>
                                <div class="my-3">
                                    <img src="<?php echo e(asset($section->section_image)); ?>" alt="Section_Image" class="rounded" height="50px" width="50px">
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="section_image" name="section_image" />
                            </div>
                            <div class="col-6">
                                <label for="more_images" class="col-form-label">More Images</label>
                                <?php if(!empty($section->encrypted_id) && !empty($section->more_images)): ?>
                                <div class="my-3">
                                    <?php
                                        $more_images = json_decode($section->more_images);
                                    ?>
                                    <?php if(!empty($section->more_images)): ?>
                                        <?php $__currentLoopData = $more_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <img src="<?php echo e(asset($image)); ?>" alt="More_Images" class="rounded" height="50px" width="50px">
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="more_images" name="more_images[]" accept=".jpg, .jpeg, .png, .webp" multiple />
                            </div>
                            <div class="col-6">
                                <label for="section_video" class="col-form-label">Section Video</label>
                                <?php if(!empty($section->encrypted_id) && !empty($section->section_video)): ?>
                                <div class="my-3">
                                    <video width="200" controls>
                                        <source src="<?php echo e(asset($section->section_video)); ?>" loop="true" autoplay muted>
                                    </video>
                                </div>
                                <?php endif; ?>
                                <input class="form-control" type="file" id="section_video" name="section_video" accept=".mp4,.mov,.avi,.mkv,.webm" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="<?php echo e(!empty($section->encrypted_id) ? 'Update Section' : 'Add Section'); ?>" class="btn btn-primary" />
                        <a href="<?php echo e(route('edit.page', $page_enc_id)); ?>" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
        <?php if(!empty($section->encrypted_id)): ?>
        <hr>
        <!-- Hoverable Table rows -->
        <div class="card mt-4">
            <h5 class="card-header">Sub-Section Management
                
                <a href="<?php echo e(route('add.page.subsection', ["page" => $page_enc_id, "section" => $section->encrypted_id])); ?>" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a>
                
                <a href="<?php echo e(route('get.sections.page', ["page" => $page_enc_id, "section" => $section->encrypted_id])); ?>" class="btn btn-primary float-end me-2">Sections Sequence</a>
            </h5>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="subsection-table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Sub-Section Title</th>
                            <th>Sub-Section Headline</th>
                            <?php if(session()->get('role') == 'superadmin'): ?>
                            <th>Sub-Section Position</th>
                            <?php endif; ?>
                            <th>Sub-Section Image</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        <?php $__currentLoopData = $subSectionsData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subSections): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?= $sno; ?></td>
                            <td><?php echo e($subSections->section_title); ?></td>
                            <td><?php echo e($subSections->section_headline); ?></td>
                            <?php if(session()->get('role') == 'superadmin'): ?>
                            <td><?php echo e($subSections->position_order); ?></td>
                            <?php endif; ?>
                            <td>
                                <?php if(!empty($subSections->section_image)): ?>
                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="<?php echo e($subSections->section_headline); ?>" >
                                        <img src="<?php echo e(asset($subSections->section_image)); ?>" alt="Sub_Section_Image" class="rounded-circle" />
                                    </li>
                                </ul>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $subSections->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $subSections->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="<?php echo e(route('edit.page.subsection', ["page" => $page_enc_id, "section" => $section->encrypted_id, "subsection" => $subSections->encrypted_id])); ?>" ><i class="bx bx-edit-alt me-1"></i> Edit</a>
                                        
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $subSections->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                        
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('admin-custom-js'); ?>
<script>
    $("#subsection-table").DataTable();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main-layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\pc\Downloads\wavedisk-api\resources\views/admin/page-section-ops.blade.php ENDPATH**/ ?>