<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Invoice - {{ $invoice->invoice_number }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            padding: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h1 {
            margin: 0;
            color: #0d6efd;
        }

        .header p {
            margin: 5px 0;
        }

        .details,
        .items {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }

        .details td {
            padding: 5px;
        }

        .details .label {
            font-weight: bold;
        }

        .items th,
        .items td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .items th {
            background-color: #f2f2f2;
        }

        .total {
            text-align: right;
            margin-top: 10px;
            font-size: 16px;
            font-weight: bold;
        }

        .footer {
            text-align: center;
            margin-top: 40px;
            font-size: 12px;
            color: #777;
        }
    </style>
</head>

<body>

    <div class="container">

        <!-- Header -->
        <div class="header">
            <h1>{{ config('app.name') }}</h1>
            <p>Invoice</p>
        </div>

        <!-- Invoice Details -->
        <table class="details">
            <tr>
                <td class="label">Invoice Number:</td>
                <td>{{ $invoice->invoice_number }}</td>
                <td class="label">Date:</td>
                <td>{{ $invoice->created_at->format('d M Y') }}</td>
            </tr>
            <tr>
                <td class="label">Customer:</td>
                <td>{{ $customer->first_name . ' ' . $customer->last_name ?? 'N/A' }}</td>
                <td class="label">E-Mail:</td>
                <td>{{ $customer->email ?? 'N/A' }}</td>
            </tr>
            <tr>
                <td class="label">Plan:</td>
                <td>{{ $plan->plan_name ?? 'N/A' }}</td>
                <td class="label">Status:</td>
                <td>{{ ucfirst($invoice->status) }}</td>
            </tr>
            <tr>
                <td class="label">Currency:</td>
                <td>{{ $invoice->currency }}</td>
                <td class="label">Transaction ID:</td>
                <td>{{ $transaction->gateway_order_id ?? '-' }}</td>
            </tr>
        </table>

        <!-- Payment Details -->
        <table class="items">
            <thead>
                <tr>
                    <th>Description</th>
                    <th>Amount ({{ $invoice->currency }})</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $plan->plan_name ?? 'Plan Payment' }}</td>
                    <td>{{ number_format($invoice->amount, 2) }}</td>
                </tr>
            </tbody>
        </table>

        <div class="total">
            Total: {{ number_format($invoice->amount, 2) }} {{ $invoice->currency }}
        </div>

        <div class="footer">
            <p>Thank you for your payment!</p>
            <p>{{ config('app.name') }} | {{ url('/') }}</p>
        </div>

    </div>

</body>

</html>
