@extends('admin.layouts.main-layout')
<?php if (!empty($subject->encrypted_id)) {
    $title = 'Edit Subject';
} else {
    $title = 'Add Subject';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($subject->encrypted_id) ? route('edit.subject', ['course' => $courseId, 'subject' => $subject->encrypted_id]) : route('add.subject', $courseId) }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a
                            href="{{ route('manage.subjects', $courseId) }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="course_ids" class="form-label">Course(s)</label>
                                        @php
                                            $selectedCourses = !empty($subject->encrypted_id)
                                                ? $subject->courses->pluck('id')->toArray()
                                                : [];
                                        @endphp
                                        <select name="course_ids[]" id="course_ids" class="form-select" multiple>
                                            @foreach ($all_subject_courses as $subject_course)
                                                <option value="{{ $subject_course->encrypted_id }}"
                                                    {{ in_array($subject_course->id, $selectedCourses) ? 'selected' : '' }}>
                                                    {{ $subject_course->course_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('course_ids')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="subject_name" class="col-form-label">Subject Name</label>
                                        <input type="text" class="form-control" id="subject_name" name="subject_name"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->subject_name : old('subject_name') }}"
                                            placeholder="Enter Name" />
                                        {{-- onblur="getUrl(this.id)" --}}
                                        @error('subject_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    {{-- <div class="col-6">
                                        <label for="subject_headline" class="col-form-label">subject Headline</label>
                                        <input type="text" class="form-control" id="subject_headline"
                                            name="subject_headline"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->subject_headline : old('subject_headline') }}"
                                            placeholder="Enter Headline" />
                                        @error('subject_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div> --}}
                                    <div class="col-6">
                                        <label for="subject_code" class="col-form-label">Subject Code</label>
                                        <input type="text" class="form-control" id="subject_code" name="subject_code"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->subject_code : old('subject_code') }}"
                                            placeholder="Enter Code" />
                                        @error('subject_code')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="course_year" class="col-form-label">Course Year</label>
                                        <input type="text" class="form-control" id="course_year" name="course_year"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->course_year : old('course_year') }}"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter Year" />
                                    </div>
                                    <div class="col-6">
                                        <label for="course_semester" class="col-form-label">Course Semester</label>
                                        <input type="text" class="form-control" id="course_semester"
                                            name="course_semester"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->course_semester : old('course_semester') }}"
                                            oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1').replace(/^(\d+\.\d{2}).*/g, '$1');"
                                            placeholder="Enter Semester" />
                                        {{-- </div>
                                    <div class="col-12">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description">{{ !empty($subject->encrypted_id) ? htmlspecialchars_decode($subject->short_description) : '' }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description">{{ !empty($subject->encrypted_id) ? htmlspecialchars_decode($subject->description) : '' }}</textarea>
                                    </div>
                                    <div class="col-6">
                                        <label for="breadcrumb_headline" class="col-form-label">Breadcrumb Headline</label>
                                        <input type="text" class="form-control" id="breadcrumb_headline"
                                            name="breadcrumb_headline"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->breadcrumb_headline : old('breadcrumb_headline') }}"
                                            placeholder="Enter Headline" />
                                        @error('breadcrumb_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div> --}}
                                        {{--
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_instagram" class="col-form-label">Writer Instagram URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_instagram" name="writer_instagram" value="{{ !empty($subject->encrypted_id) ? $subject->writer_instagram : '' }}" placeholder="Enter Instagram URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_linkedin" class="col-form-label">Writer LinkedIn URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_linkedin" name="writer_linkedin" value="{{ !empty($subject->encrypted_id) ? $subject->writer_linkedin : '' }}" placeholder="Enter LinkedIn URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_x" class="col-form-label">Writer X URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_x" name="writer_x" value="{{ !empty($subject->encrypted_id) ? $subject->writer_x : '' }}" placeholder="Enter X URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_facebook" class="col-form-label">Writer Facebook URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_facebook" name="writer_facebook" value="{{ !empty($subject->encrypted_id) ? $subject->writer_facebook : '' }}" placeholder="Enter Facebook URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_threads" class="col-form-label">Writer Instagram Threads URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_threads" name="writer_threads" value="{{ !empty($subject->encrypted_id) ? $subject->writer_threads : '' }}" placeholder="Enter Instagram Threads URL" />-->
                                <!--</div>-->
                                --}}
                                        {{-- <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->meta_title : '' }}"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="{{ !empty($subject->encrypted_id) ? $subject->meta_keyword : '' }}"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description">{{ !empty($subject->encrypted_id) ? htmlspecialchars_decode($subject->meta_description) : '' }}</textarea>
                                    </div> --}}
                                    </div>
                                </div>
                            </div>
                            {{-- <div class="row">
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="blog_image" class="col-form-label">Blog Image</label>
                                        @if (!empty($subject->encrypted_id) && !empty($subject->blog_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($subject->blog_image) }}" alt="Blog_Image"
                                                    class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="blog_image" name="blog_image"
                                            accept="image/*" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="writer_image" class="col-form-label">Writer Image</label>
                                        @if (!empty($subject->encrypted_id) && !empty($subject->writer_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($subject->writer_image) }}" alt="Writer_Image"
                                                    class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="writer_image" name="writer_image"
                                            accept="image/*" />
                                    </div>
                                </div>
                            </div>
                        </div> --}}
                            <div class="demo-inline-spacing">
                                <input type="submit"
                                    value="{{ !empty($subject->encrypted_id) ? 'Update Subject' : 'Add Subject' }}"
                                    class="btn btn-primary" />
                                <a href="{{ route('manage.subjects', $courseId) }}"
                                    class="btn btn-outline-secondary">Back</a>
                            </div>
                        </div>
                    </div>
                    <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>
    {{-- <script>
        function getUrl(field_id) {
            let errors = 0;
            let blog_headline = $.trim($("#" + field_id).val());
            let id = "{{ !empty($subject->encrypted_id) ? $subject->encrypted_id : '' }}";

            // Replace '/' and spaces with '-'
            let blog_url = blog_headline.replace(/[\/\s]+/g, '-').toLowerCase();

            if (blog_headline == "" || blog_headline == undefined || blog_headline == null) {
                errors += 1;
            }
            if (blog_url == "" || blog_url == undefined || blog_url == null) {
                errors += 1;
            }

            if (errors > 0) {
                $("#blog_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                blog_url = blog_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.blog.link', ['blog_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', blog_url)
                    .replace('__ID__', id);

                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("blog_url").value = data; // Update input field with returned link
                        // $("#blog_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script> --}}

@endsection
