@extends('admin.layouts.main-layout')
@php
    if (!empty($session->encrypted_id)) {
        $title = 'Edit Session';
    } else {
        $title = 'Add Session';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($session->encrypted_id) ? route('edit.session', ['session' => $session->encrypted_id]) : route('add.session') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.sessions') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="session_name" class="col-form-label">Session Name</label>
                                        <input type="text" class="form-control" id="session_name" name="session_name"
                                            value="{{ !empty($session->encrypted_id) ? $session->session_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('session_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="submit"
                            value="{{ !empty($session->encrypted_id) ? 'Update Session' : 'Add Session' }}"
                            class="btn btn-primary" />
                        <a href="{{ route('manage.sessions') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    {{--
    <script>
        function getUrl(field_id) {
            let errors = 0;
            let session_name = $.trim($("#" + field_id).val());
            let id = "{{ !empty($session->encrypted_id) ? $session->encrypted_id : '' }}";
            // Replace '/' and spaces with '-'
            let session_url = session_name.replace(/[\/\s]+/g, '-').toLowerCase();
            if (session_name == "" || session_name == undefined || session_name == null) {
                errors += 1;
            }
            if (session_url == "" || session_url == undefined || session_url == null) {
                errors += 1;
            }
            if (errors > 0) {
                $("#session_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                session_url = session_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');
                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.session.link', ['session_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', session_url)
                    .replace('__ID__', id);
                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("session_url").value =
                        data; // Update input field with returned session_url
                        // $("#session_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>
    --}}
@endsection
