@extends('admin.layouts.main-layout')
<?php if(!empty($service->encrypted_id)) {
    $title = "Edit Service";
} else {
    $title = "Add Service";
}
?>
@section('title', $title)
@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($service->encrypted_id) ? route('edit.service', $service->encrypted_id) : route('add.service') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header">{{ $title }}<span class="float-end"><a href="{{ route('manage_services') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @elseif (session('success'))
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="header_footer_name" class="col-form-label">Name in Header & Footer</label>
                                    <input type="text" class="form-control" id="header_footer_name" name="header_footer_name" value="{{ !empty($service->encrypted_id) ? $service->header_footer_name : '' }}" placeholder="Enter Name for Header & Footer" />
                                    @error('header_footer_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-6">
                                    <label for="service_template" class="form-label">Service Template</label>
                                    <select name="service_template" id="service_template" class="form-select">
                                        @if(!empty($service->encrypted_id))
                                        <option value="individual-tax" {{ $service->service_template == 'individual-tax' ? "selected" : "" }}>Individual Tax</option>
                                        <option value="business-tax" {{ $service->service_template == 'business-tax' ? "selected" : "" }}>Business Tax</option>
                                        <option value="bookkeeping" {{ $service->service_template == 'bookkeeping' ? "selected" : "" }}>Book-Keeping</option>
                                        <option value="business-registration" {{ $service->service_template == 'business-registration' ? "selected" : "" }}>Business Registration</option>
                                        <option value="common" {{ $service->service_template == 'common' ? "selected" : "" }}>Common</option>
                                        @else
                                        <option value="" selected>-- Select Template --</option>
                                        <option value="individual-tax">Individual Tax</option>
                                        <option value="business-tax">Business Tax</option>
                                        <option value="bookkeeping">Book-Keeping</option>
                                        <option value="business-registration">Business Registration</option>
                                        <option value="common">Common</option>
                                        @endif
                                    </select>
                                    @error('service_template')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-6">
                                    <label for="service_name" class="col-form-label">Service Name</label>
                                    <input type="text" class="form-control" id="service_name" name="service_name" value="{{ !empty($service->encrypted_id) ? $service->service_name : '' }}" placeholder="Enter Name" onblur="getUrl(this.id)" />
                                    @error('service_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-6">
                                    <label for="service_url" class="col-form-label">Service URL</label>
                                    <input type="text" class="form-control" id="service_url" name="service_url" value="{{ !empty($service->encrypted_id) ? $service->service_url : '' }}" placeholder="Enter URL" />
                                    @error('service_url')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-6">
                                    <label for="blogs" class="form-label">Blog(s)</label>
                                    <select name="blogs[]" id="blogs" class="form-select" multiple>
                                        @foreach($blogs as $blog)
                                            @if(!empty($service->encrypted_id))
                                            <option value="{{ $blog->encrypted_id }}" {{ in_array($blog->id, $service->blogs) ? "selected" : "" }}>{{ $blog->blog_headline }}</option>
                                            @else
                                            <option value="{{ $blog->encrypted_id }}">{{ $blog->blog_headline }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('blogs')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($service->encrypted_id) ? htmlspecialchars_decode($service->description) : '' }}</textarea>
                                </div>
                                <div class="col-6">
                                    <label for="breadcrumb_headline" class="col-form-label">Breadcrumb Headline</label>
                                    <input type="text" class="form-control" id="breadcrumb_headline" name="breadcrumb_headline" value="{{ !empty($service->encrypted_id) ? $service->breadcrumb_headline : '' }}" placeholder="Enter Breadcrumb Headline" />
                                </div>
                                <div class="col-12">
                                    <label for="breadcrumb_description" class="col-form-label">Breadcrumb Description</label>
                                    <textarea name="breadcrumb_description" id="breadcrumb_description" cols="30" rows="5" class="form-control" placeholder="Enter Breadcrumb Description" >{{ !empty($service->encrypted_id) ? htmlspecialchars_decode($service->breadcrumb_description) : '' }}</textarea>
                                </div>
                                <div class="col-6">
                                    <label for="button_name" class="col-form-label">Button Name</label>
                                    <input type="text" class="form-control" id="button_name" name="button_name" value="{{ !empty($service->encrypted_id) ? $service->button_name : '' }}" placeholder="Enter Name" />
                                </div>
                                <div class="col-6"></div>
                                <div class="col-6">
                                    <label for="meta_title" class="col-form-label">Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ !empty($service->encrypted_id) ? $service->meta_title : '' }}" placeholder="Enter Meta Title" />
                                </div>
                                <div class="col-6">
                                    <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="{{ !empty($service->encrypted_id) ? $service->meta_keyword : '' }}" placeholder="Enter Meta Keyword" />
                                </div>
                                <div class="col-12">
                                    <label for="meta_description" class="col-form-label">Meta Description</label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" >{{ !empty($service->encrypted_id) ? htmlspecialchars_decode($service->meta_description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="service_image" class="col-form-label">Service Image</label>
                                @if(!empty($service->encrypted_id) && !empty($service->service_image))
                                <div class="my-3">
                                    <img src="{{ asset($service->service_image) }}" alt="Service_Image" class="rounded" height="50px" width="50px">
                                </div>
                                @endif
                                <input class="form-control" type="file" id="service_image" name="service_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <h5 class="card-header">FAQ Management</h5>
                    <div id="service-faqs"></div>
                    <span class="float-end"><button type="button" id="add-faq-row" class="btn rounded-pill btn-icon btn-primary float-end" style="font-size: 1.7em;">+</button></span>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($service->encrypted_id) ? 'Update Service' : 'Add Service' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_services') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

<script>
    new MultiSelectTag('blogs')  // id
</script>

<script>

    function getUrl(field_id) {
        let errors = 0;
        let service_name = $.trim($("#" + field_id).val());
        let id = "{{ !empty($service->encrypted_id) ? $service->encrypted_id : '' }}";

        // Replace '/' and spaces with '-'
        let service_url = service_name.replace(/[\/\s]+/g, '-').toLowerCase();

        if(service_name == "" || service_name == undefined || service_name == null) {
            errors += 1;
        }
        if(service_url == "" || service_url == undefined || service_url == null) {
            errors += 1;
        }

        if(errors > 0) {
            $("#service_url").val("");
            return false;
        }
        else {
            // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
            service_url = service_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

            // Use Blade to generate the base route and append parameters dynamically
            let url = "{{ route('check.service.link', ['service_url' => '__LINK__', 'id' => '__ID__']) }}"
                .replace('__LINK__', service_url)
                .replace('__ID__', id);

            // Send GET request with parameters in the URL
            fetch(url)
                .then(response => response.text()) // Expecting plain text response
                .then(data => {
                    document.getElementById("service_url").value = data; // Update input field with returned link
                    // $("#service_url").val(data);
                })
                .catch(error => console.error("Error:", error));
        }
    }

</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        let faqCount = 1;

        // Function to add a new row
        function addFaqRow(item = {}) {
            
            // Create the main card div
            const card = document.createElement('div');
            card.className = 'card mb-4';
            card.id = `row-${faqCount}`;
            
            // Create the card body
            const cardBody = document.createElement('div');
            cardBody.className = 'card-body';
            
            // Hidden input for ID
            const idInput = document.createElement('input');
            idInput.type = 'hidden';
            idInput.name = 'faqs[]';
            idInput.value = item.faq_id || '';
            cardBody.appendChild(idInput);
            
            // Create the first row (Section Headline)
            const row1 = document.createElement('div');
            row1.className = 'row mb-3';
            
            // Label for Section Headline
            const label1 = document.createElement('label');
            label1.htmlFor = `faqQuestion-${faqCount}`;
            label1.className = 'col-form-label';
            label1.textContent = 'FAQ Question';
            
            // Input for Section Headline
            const col1 = document.createElement('div');
            col1.className = 'col-sm-12';
            
            const input1 = document.createElement('input');
            input1.type = 'text';
            input1.className = 'form-control';
            input1.id = `faqQuestion-${faqCount}`;
            input1.name = 'faq_questions[]';
            input1.placeholder = 'Enter Question';
            input1.value = item.faq_question || '';
            input1.required = true;
            
            // Prevent removal of the required attribute
            Object.defineProperty(input1, 'required', {
                configurable: false,
                writable: false,
                value: true,
            });
            
            // Append input to column and label + column to row
            col1.appendChild(input1);
            row1.appendChild(label1);
            row1.appendChild(col1);
            
            // Create the second row (Short Description)
            const row2 = document.createElement('div');
            row2.className = 'row mb-3';
            
            // Textarea for Short Description
            const col2 = document.createElement('div');
            col2.className = 'col-sm-12';
            
            // Label for Short Description
            const label2 = document.createElement('label');
            label2.htmlFor = `faqAnswer-${faqCount}`;
            label2.className = 'col-form-label';
            label2.textContent = 'FAQ Answer';
            
            const textarea = document.createElement('textarea');
            textarea.id = `faqAnswer-${faqCount}`;
            textarea.name = 'faq_answers[]';
            textarea.cols = 30;
            textarea.rows = 5;
            textarea.className = 'faq-text-area form-control';
            textarea.placeholder = 'Enter Answer';
            textarea.textContent = item.faq_answer || '';
            
            // Append textarea to column and label + column to row
            row2.appendChild(label2);
            col2.appendChild(textarea);
            row2.appendChild(col2);
            
            // Button div
            const buttonsDiv = document.createElement('div');
            buttonsDiv.classList.add('float-end');
            
            // Remove Button
            const removeButton = document.createElement('button');
            removeButton.type = 'button';
            removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
            removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
            removeButton.onclick = function () {
                if(item && item.faq_id) {
                    $.ajax({
                        url: "{{ route('delete.service.faq') }}",
                        method: "POST",
                        data: {'faq': item.faq_id, '_token': '{{ csrf_token() }}'},
                        success: function(res) {
                            card.remove();
                        }
                    });
                }
                else {
                    card.remove();
                }
            };
            buttonsDiv.appendChild(removeButton);
            
            // Append rows to card body
            // cardBody.appendChild(row11);
            cardBody.appendChild(row1);
            cardBody.appendChild(row2);
            cardBody.appendChild(buttonsDiv);
            
            // Append card body to card
            card.appendChild(cardBody);

            // Append the new row to the form
            document.getElementById('service-faqs').appendChild(card);
            
            // Initialize TinyMCE for the newly created textarea
            tinymce.init({
                selector: `.faq-text-area`, // Target the newly created textarea by its ID
                plugins: 'a11ychecker advcode advlist advtable anchor autocorrect autolink autoresize autosave casechange charmap checklist code codesample directionality editimage emoticons export footnotes formatpainter fullscreen help image importcss inlinecss insertdatetime link linkchecker lists media mediaembed mentions mergetags nonbreaking pagebreak pageembed permanentpen powerpaste preview quickbars save searchreplace table tableofcontents template tinycomments tinydrive tinymcespellchecker typography visualblocks visualchars wordcount',
                toolbar: 'undo redo | blocks| bold italic | bullist numlist checklist | code | table | alignleft aligncenter alignright alignjustify | outdent indent | wordcount | a11ycheck advtablerownumbering typopgraphy anchor restoredraft casechange charmap checklist code codesample addcomment showcomments ltr rtl editimage fliph flipv imageoptions rotateleft rotateright emoticons export footnotes footnotesupdate formatpainter fullscreen help image insertdatetime link openlink unlink bullist numlist media mergetags mergetags_list nonbreaking pagebreak pageembed permanentpen preview quickimage quicklink quicktable cancel save searchreplace spellcheckdialog spellchecker',
                resize: 'both'
            });
            
            faqCount++;
        }

        @if(!empty($service->encrypted_id))

        // Fetch data from the server (get_sub_section_data.php) and add rows
        fetch("{{ route('get.service.faqs', $service->encrypted_id) }}")
            .then(response => response.json())
            .then(data => {
                data.forEach(item => {
                    addFaqRow(item);
                });
            });
            
        @endif

        // Event listener to add a new blank row when "Add Row" button is clicked
        document.getElementById('add-faq-row').addEventListener('click', () => {
            addFaqRow();
        });
    });
</script>

@endsection
