@extends('admin.layouts.main-layout')
<?php if (!empty($plan->encrypted_id)) {
    $title = 'Edit Plan';
} else {
    $title = 'Add Plan';
}
?>
@section('title', $title)
@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form action="{{ !empty($plan->encrypted_id) ? route('edit.plan', $plan->encrypted_id) : route('add.plan') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.plans') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="plan_name" class="col-form-label">Plan Name</label>
                                        <input type="text" class="form-control" id="plan_name" name="plan_name"
                                            value="{{ !empty($plan->encrypted_id) ? $plan->plan_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('plan_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="plan_category" class="form-label">Plan Category</label>
                                        <select name="plan_category" id="plan_category" class="form-select">
                                            @if (!empty($plan->encrypted_id))
                                                <option value="popular"
                                                    {{ $plan->plan_category == 'popular' ? 'selected' : '' }}>Popular
                                                </option>
                                                {{-- <!--<option value="year" {{ $plan->plan_category == 'year' ? "selected" : "" }}>Yearly</option>--> --}}
                                            @else
                                                <option value="" selected>-- Select Category --</option>
                                                <option value="popular">Popular</option>
                                                {{-- <!--<option value="year">Yearly</option>--> --}}
                                            @endif
                                        </select>
                                        @error('plan_category')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="plan_price" class="col-form-label">Plan Price</label>
                                        <input type="number" step="0.01" min="0" class="form-control"
                                            id="plan_price" name="plan_price"
                                            value="{{ !empty($plan->encrypted_id) ? $plan->plan_price : '' }}"
                                            placeholder="Enter Price" pattern="^\d+(\.\d{1,2})?$" />
                                        @error('plan_price')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="plan_price_base" class="form-label">Plan per Base</label>
                                        <select name="plan_price_base" id="plan_price_base" class="form-select">
                                            @if (!empty($plan->encrypted_id))
                                                <option value="month"
                                                    {{ $plan->plan_price_base == 'month' ? 'selected' : '' }}>Monthly
                                                </option>
                                                <option value="year"
                                                    {{ $plan->plan_price_base == 'year' ? 'selected' : '' }}>Yearly
                                                </option>
                                            @else
                                                <option value="" selected>-- Select Price Base --</option>
                                                <option value="month">Monthly</option>
                                                <option value="year">Yearly</option>
                                            @endif
                                        </select>
                                        @error('plan_price_base')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="plan_storage_limit" class="col-form-label">Plan Storage Limit <small>(In
                                                GB format)</small></label>
                                        <input type="number" step="0" min="0" class="form-control"
                                            id="plan_storage_limit" name="plan_storage_limit"
                                            value="{{ !empty($plan->encrypted_id) ? $plan->plan_storage_limit : '' }}"
                                            placeholder="Enter Plan Storage Limit" pattern="^\d+(\.\d{1,2})?$" />
                                        @error('plan_storage_limit')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-12">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea name="short_description" id="short_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Description">{{ !empty($plan->encrypted_id) ? htmlspecialchars_decode($plan->short_description) : '' }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea name="description" id="description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Description">{{ !empty($plan->encrypted_id) ? htmlspecialchars_decode($plan->description) : '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card">
                            <div class="card-body row">
                                <div class="col-12">
                                    <label for="plan_image" class="col-form-label">Plan Image</label>
                                    @if (!empty($plan->encrypted_id) && !empty($plan->plan_image))
                                        <div class="my-3">
                                            <img src="{{ asset($plan->plan_image) }}" alt="Feature_Image"
                                                class="rounded" height="50px" width="50px">
                                        </div>
                                    @endif
                                    <input class="form-control" type="file" id="plan_image" name="plan_image"
                                        accept="image/*" />
                                </div>
                            </div>
                        </div>
                        <div class="demo-inline-spacing">
                            <input type="submit" value="{{ !empty($plan->encrypted_id) ? 'Update Plan' : 'Add Plan' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.plans') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>
@endsection
