@extends('admin.layouts.main-layout')
<?php if(!empty($partner->encrypted_id)) {
    $title = "Edit Partner";
} else {
    $title = "Add Partner";
}
?>
@section('title', $title)
@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($partner->encrypted_id) ? route('edit.partner', $partner->encrypted_id) : route('add.partner') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage.partners') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="partner_name" class="col-form-label">Partner Name</label>
                                    <input type="text" class="form-control" id="partner_name" name="partner_name" value="{{ !empty($partner->encrypted_id) ? $partner->partner_name : '' }}" placeholder="Enter Name" />
                                    @error('partner_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="partner_image" class="col-form-label">Partner Image</label>
                                @if(!empty($partner->encrypted_id) && !empty($partner->partner_image))
                                <div class="my-3">
                                    <img src="{{ asset($partner->partner_image) }}" alt="Partner_Image" class="rounded" height="50px" width="50px">
                                </div>
                                @endif
                                <input class="form-control" type="file" id="partner_image" name="partner_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($partner->encrypted_id) ? "Update Partner" : "Add Partner" }}" class="btn btn-primary" />
                        <a href="{{ route('manage.partners') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
@endsection