@extends('admin.layouts.main-layout')
@section('title', 'Manage Sub-Service Sections')
@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        @if (session('success'))
            <div class="alert alert-success alert-dismissible" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif
        <!-- Hoverable Table rows -->
        <div class="card">
            @php
                $flow = '<span class="text-danger">'.$sub_service->service_name.'</span>';
                if(isset($parent_section) && !empty($parent_section)) {
                    $flow .= ' -> '. '<span class="text-warning">'.$parent_section->section_headline.'</span>';
                }
            @endphp
            <span class="card-header"><h5><?= $flow.' -> '; ?>Manage Sub-Service Sections</h5>
                @if(isset($enc_parent_section) && !empty($enc_parent_section))
                    <a href="{{ route('add.subservice.sub.section', ["subservice" => $enc_subservice, "parent" => $enc_parent_section]) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end ms-2" style="font-size: 1.7em;">+</a>
                    @if(isset($enc_super_parent) && !empty($enc_super_parent))
                        <a href="{{ route('get.subservice.sub.sections', ["subservice" => $enc_subservice, "parent" => $enc_super_parent]) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                    @else
                        <a href="{{ route('get.subservice.sections', ["subservice" => $enc_subservice]) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                    @endif
                    {{-- <a href="{{ route('get.service.sections.page', $enc_subservice) }}" class="btn btn-primary float-end me-2">Service Sections Sequence</a> --}}
                @else
                    <a href="{{ route('add.subservice.section', $enc_subservice) }}" class="btn rounded-pill btn-icon btn-outline-primary float-end ms-2" style="font-size: 1.7em;">+</a>
                    <a href="{{ route('get.subservices', $enc_super_service) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a>
                    {{-- <a href="{{ route('get.service.sections.page', $enc_subservice) }}" class="btn btn-primary float-end me-2">Service Sections Sequence</a> --}}
                @endif
            </span>
            <div class="table-responsive text-nowrap px-4 pb-4">
                <table id="table" class="table table-hover">
                    <thead>
                        <tr>
                            <th>S. No.</th>
                            <th>Section Name & Sub-Sections</th>
                            <th>Section Position</th>
                            <th>Section Image</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody class="table-border-bottom-0">
                        <?php $sno = 1; ?>
                        @foreach($sectionsData as $sections)
                        <tr>
                            <td><?= $sno; ?>.</td>
                            <td>
                                @if(isset($sections->encrypted_id) && !empty($sections->encrypted_id))
                                <a href="{{ route('get.subservice.sub.sections', ["subservice" => $enc_subservice, "parent" => $sections->encrypted_id]) }}">
                                    <strong>{{ $sections->section_headline }}</strong>
                                </a>
                                @else
                                <a href="{{ route('get.subservice.sections', $enc_subservice) }}">
                                    <strong>{{ $sections->section_headline }}</strong>
                                </a>
                                @endif
                            </td>
                            <td>{{ $sections->position_order }}</td>
                            <td>
                                @if($sections->section_image)
                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">
                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="{{ $sections->section_headline }}" >
                                        <img src="{{ asset($sections->section_image) }}" alt="Section_Image" class="rounded-circle" />
                                    </li>
                                </ul>
                                @endif
                            </td>
                            <td>
                                <div class="form-check form-switch mb-2">
                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $sections->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $sections->status == 'active' ? 'checked' : ''; ?> />
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="bx bx-dots-vertical-rounded"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        @if(isset($enc_parent_section) && !empty($enc_parent_section))
                                        <a class="dropdown-item" href="{{ route('edit.subservice.sub.section', ["subservice" => $enc_subservice, "parent" => $enc_parent_section, "section" => $sections->encrypted_id]) }}" >
                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                        </a>
                                        @else
                                        <a class="dropdown-item" href="{{ route('edit.subservice.section', ["subservice" => $enc_subservice, "section" => $sections->encrypted_id]) }}" >
                                            <i class="bx bx-edit-alt me-1"></i> Edit
                                        </a>
                                        @endif
                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $sections->encrypted_id; ?>');" >
                                            <i class="bx bx-trash me-1"></i> Delete
                                        </button>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        <?php $sno++; ?>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!--/ Hoverable Table rows -->
    </div>
</div>
@endsection
@section('admin-custom-js')
<script>
    $("#table").DataTable();
</script>
@endsection