@php
    $websiteData = resolve(App\Http\Controllers\Admin\CompanyController::class)->getCompanyData();
@endphp
@include('admin.includes.header')
@yield('admin-custom-css')
@include('admin.ajax.operations')

<!-- Layout wrapper -->
<div class="layout-wrapper layout-content-navbar">
    <div class="layout-container">
        <!-- Menu -->
        @include('admin.includes.sidebar')
        <!-- Layout container -->
        <div class="layout-page">
            <!-- Navbar -->
            @include('admin.includes.navbar')
            <!-- / Navbar -->

            @yield('content')

            <footer class="content-footer footer bg-footer-theme">
                <div class="container-xxl d-flex flex-wrap justify-content-between py-2 flex-md-row flex-column">
                    <div class="mb-2 mb-md-0">
                        ©
                        <?= date("Y"); ?>
                        , Made with ❤️ by
                        <a href="https://www.matebiz.com/" target="_blank" class="footer-link fw-bolder">MateBiz</a>
                    </div>
                </div>
            </footer>
            <!-- / Footer -->
        </div>
        <!-- / Layout page -->
    </div>

    <!-- Overlay -->
    <div class="layout-overlay layout-menu-toggle"></div>

    {{-- <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#select-image-from-all-images">
        Extra Large
    </button> --}}

    {{-- <div class="modal fade" id="select-image-from-all-images" tabindex="-1" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel4">All Images</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body mb-4">
                    <div class="row">
                        <div class="col-6">
                            <input type="file" id="upload_images_input" class="form-control" accept="image/*" multiple>
                            @error('upload_images')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="col-6" id="upload-loding-image"></div>
                    </div>
                    <hr>
                    {{-- <div id="images-preview"> 
                        <span class="pe-2 mb-2">
                            <input type="radio" name="selected-image" id="selected-image-1">
                            <img src="{{ asset('storage/'. $profile->image) }}" alt="Image Name" width="100px" height="100px">
                        </span>
                        <span class="pe-2 mb-2">
                            <input type="radio" name="selected-image" id="selected-image-2">
                            <img src="{{ asset('storage/'. $profile->image) }}" alt="Image Name" width="100px" height="100px">
                        </span>
                        {{-- <div class="row g-2">
                            <div class="col mb-0">
                                <label for="emailExLarge" class="form-label">Email</label>
                                <input type="text" id="emailExLarge" class="form-control" placeholder="xxxx@xxx.xx">
                            </div>
                            <div class="col mb-0">
                                <label for="dobExLarge" class="form-label">DOB</label>
                                <input type="text" id="dobExLarge" class="form-control" placeholder="DD / MM / YY">
                            </div>
                        </div> 
                    {{-- </div> 
                </div>
                {{-- <div class="modal-footer">
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">
                        Close
                    </button>
                    <button type="button" class="btn btn-primary">Save changes</button>
                </div> 
            </div>
        </div>
    </div> --}}
</div>

{{-- <script>

    $(document).ready(function () {
        $("#upload_images_input").on("change", function () {
            var files = this.files; // Get selected files
            var formData = new FormData();
            formData.append("_token", '{{ csrf_token() }}');
            
            if (files.length === 0) {
                alert("Please select at least one image.");
                return false;
            }

            // Append all selected images to FormData
            $.each(files, function (index, file) {
                formData.append("upload_images[]", file);
            });

            // Display selected images before upload
            // $("#images-preview").empty(); // Clear previous images
            // $.each(files, function (index, file) {
            //     var reader = new FileReader();
            //     reader.onload = function (e) {
            //         $("#images-preview").append('<img src="' + e.target.result + '" width="100" height="100" style="margin:5px;">');
            //     };
            //     reader.readAsDataURL(file);
            // });

            $("#upload-loding-image").html('<img src="{{ asset('admin-assets/assets/loading-spinner-final.svg') }}" loading="lazy" alt="Loading_Image" height="40px" width="40px">');

            // Send images to the server via AJAX
            $.ajax({
                url: "{{ route('upload.images') }}", // Laravel route
                type: "POST",
                data: formData,
                processData: false,
                contentType: false,
                success: function (response) {
                    console.log(response);
                    alert("Images uploaded successfully!");
                },
                error: function (xhr, status, error) {
                    console.error("Error:", error);
                },
            });
        });
    });

</script> --}}

@yield('admin-custom-js')

@include('admin.includes.footer')
