@extends('admin.layouts.main-layout')
@php
    if (!empty($language->encrypted_id)) {
        $title = 'Edit Language';
    } else {
        $title = 'Add Language';
    }
@endphp
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($language->encrypted_id) ? route('edit.language', ['language' => $language->encrypted_id]) : route('add.language') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.medium') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <label for="language_name" class="col-form-label">Language Name</label>
                                        <input type="text" class="form-control" id="language_name" name="language_name"
                                            value="{{ !empty($language->encrypted_id) ? $language->language_name : '' }}"
                                            placeholder="Enter Name" />
                                        @error('language_name')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="submit"
                            value="{{ !empty($language->encrypted_id) ? 'Update Language' : 'Add Language' }}"
                            class="btn btn-primary" />
                        <a href="{{ route('manage.medium') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

    {{--
    <script>
        function getUrl(field_id) {
            let errors = 0;
            let language_name = $.trim($("#" + field_id).val());
            let id = "{{ !empty($language->encrypted_id) ? $language->encrypted_id : '' }}";
            // Replace '/' and spaces with '-'
            let language_url = language_name.replace(/[\/\s]+/g, '-').toLowerCase();
            if (language_name == "" || language_name == undefined || language_name == null) {
                errors += 1;
            }
            if (language_url == "" || language_url == undefined || language_url == null) {
                errors += 1;
            }
            if (errors > 0) {
                $("#language_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                language_url = language_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');
                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.language.link', ['language_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', language_url)
                    .replace('__ID__', id);
                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("language_url").value =
                        data; // Update input field with returned language_url
                        // $("#language_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>
    --}}
@endsection
