@extends('admin.layouts.main-layout')
<?php if(!empty($feature->encrypted_id)) {
    $title = "Edit Feature";
} else {
    $title = "Add Feature";
}
?>
@section('title', $title)
@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($feature->encrypted_id) ? route('edit.feature', $feature->encrypted_id) : route('add.feature') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage.features') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-12">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-6">
                                    <label for="feature_headline" class="col-form-label">Feature Headline</label>
                                    <input type="text" class="form-control" id="feature_headline" name="feature_headline" value="{{ !empty($feature->encrypted_id) ? $feature->feature_headline : '' }}" placeholder="Enter Headline" />
                                    @error('feature_headline')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-12">
                                    <label for="description" class="col-form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($feature->encrypted_id) ? htmlspecialchars_decode($feature->description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body row">
                            <div class="col-12">
                                <label for="feature_image" class="col-form-label">Feature Image</label>
                                @if(!empty($feature->encrypted_id) && !empty($feature->feature_image))
                                <div class="my-3">
                                    <img src="{{ asset($feature->feature_image) }}" alt="Feature_Image" class="rounded" height="50px" width="50px">
                                </div>
                                @endif
                                <input class="form-control" type="file" id="feature_image" name="feature_image" accept="image/*" />
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($feature->encrypted_id) ? "Update Feature" : "Add Feature" }}" class="btn btn-primary" />
                        <a href="{{ route('manage.features') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>
@endsection