@extends('admin.admin-layouts.main-layout')
<?php if(!empty($table_content)) {
    $title = "Edit Table Content";
} else {
    $title = "Add Table Content";
}

?>

@section('title', $title)

@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        <form action="{{ !empty($table_content) ? route('edit.comparison', $table_content->encrypted_id) : route('add.comparison') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <!-- Hoverable Table rows -->

            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_cost_comparison') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>

            <div class="row">

                <div class="col-md-9 mx-auto">

                    @if (session('error'))

                    <div class="alert alert-danger alert-dismissible" role="alert">

                        {{ session('error') }}

                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

                    </div>

                    @endif

                    <div class="card mb-4">

                        <div class="card-body">

                            <div class="row mb-3">

                                <label for="position_order" class="col-sm-3 col-form-label">Content Position</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($table_content) ? $table_content->position_order : '' }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="treatment" class="col-sm-3 col-form-label">Treatment</label>

                                <div class="col-sm-9">

                                    @php $create = true; @endphp

                                    <select name="treatment" id="treatment" class="form-control">

                                        @foreach($treatmentsData as $treatments)

                                            @if(!empty($table_content))

                                            <option value="{{ $treatments->encrypted_id }}" {{ ($table_content->treatment_id == $treatments->id) ? "selected" : "" }}>{{ $treatments->treatment_headline }}</option>

                                            @else

                                                @if($create == true)

                                                <option value="" selected>--- Select Treatment ---</option>

                                                @php $create = false; @endphp

                                                @endif

                                            <option value="{{ $treatments->encrypted_id }}">{{ $treatments->treatment_headline }}</option>

                                            @endif

                                        @endforeach

                                    </select>

                                    @error('treatment')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="section" class="col-sm-3 col-form-label">Section</label>

                                <div class="col-sm-9">

                                    @php $create = true; @endphp

                                    <select name="section" id="section" class="form-control">

                                        @foreach($sectionsData as $sections)

                                            @if(!empty($table_content))

                                            <option value="{{ $sections->encrypted_id }}" {{ ($table_content->section_id == $sections->id) ? "selected" : "" }}>{{ $sections->section_headline }}</option>

                                            @else

                                                @if($create == true)

                                                <option value="" selected>--- Select Section ---</option>

                                                @php $create = false; @endphp

                                                @endif

                                            <option value="{{ $sections->encrypted_id }}">{{ $sections->section_headline }}</option>

                                            @endif

                                        @endforeach

                                    </select>

                                    @error('section')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="us_cost" class="col-sm-3 col-form-label">Cost ( In USA )</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="us_cost" name="us_cost" value="{{ !empty($table_content) ? $table_content->us_cost : '' }}" placeholder="Enter Cost ( In USA )" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="costa_rica_cost" class="col-sm-3 col-form-label">Cost ( In Costa Rica )</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="costa_rica_cost" name="costa_rica_cost" value="{{ !empty($table_content) ? $table_content->costa_rica_cost : '' }}" placeholder="Enter Cost ( In Costa Rica )" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="india_cost" class="col-sm-3 col-form-label">Cost ( In India )</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="india_cost" name="india_cost" value="{{ !empty($table_content) ? $table_content->india_cost : '' }}" placeholder="Enter Cost ( In India )" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="korea_cost" class="col-sm-3 col-form-label">Cost ( In Korea )</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="korea_cost" name="korea_cost" value="{{ !empty($table_content) ? $table_content->korea_cost : '' }}" placeholder="Enter Cost ( In Korea )" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="thailand_cost" class="col-sm-3 col-form-label">Cost ( In Thailand )</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="thailand_cost" name="thailand_cost" value="{{ !empty($table_content) ? $table_content->thailand_cost : '' }}" placeholder="Enter Cost ( In Thailand )" />

                                </div>

                            </div>

                            <div class="row mb-3">

                                <label for="maxico_cost" class="col-sm-3 col-form-label">Cost ( In Maxico )</label>

                                <div class="col-sm-9">

                                    <input type="text" class="form-control" id="maxico_cost" name="maxico_cost" value="{{ !empty($table_content) ? $table_content->maxico_cost : '' }}" placeholder="Enter Cost ( In Maxico )" />

                                </div>

                            </div>

                        </div>

                    </div>

                    <div class="demo-inline-spacing">

                        <input type="submit" value="{{ !empty($table_content) ? 'Update Section' : 'Add Section' }}" class="btn btn-primary" />

                        <a href="{{ route('manage_cost_comparison') }}" class="btn btn-outline-secondary">Back</a>

                    </div>

                </div>

            </div>

            <!--/ Hoverable Table rows -->

        </form>

    </div>

</div>



@endsection

