@extends('admin.admin-layouts.main-layout')

@section('title', 'Manage Partners')



@section('content')

<!-- Content wrapper -->

<div class="content-wrapper">

    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">

        @if (session('success'))

            <div class="alert alert-success alert-dismissible" role="alert">

                {{ session('success') }}

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>

            </div>

        @endif

        <!-- Hoverable Table rows -->

        <div class="card">

            <h5 class="card-header">Manage Partners<a href="{{ route('add.partner') }}" class="btn rounded-pill btn-icon btn-outline-primary float-end" style="font-size: 1.7em;">+</span></a></h5>

            <div class="table-responsive text-nowrap px-4 pb-4">

                <table id="table" class="table table-hover">

                    <thead>

                        <tr>

                            <th>S. No.</th>

                            <th>Partner Name</th>

                            <th>Partner Image</th>

                            <th>Partner Country Name</th>

                            {{-- <th>Partner 3rd Party Links</th> --}}

                            <th>Partner Position</th>

                            <th>Status</th>

                            <th>Actions</th>

                        </tr>

                    </thead>

                    <tbody class="table-border-bottom-0">

                        <?php $sno = 1; ?>

                        @foreach($partnersData as $partners)

                        <tr>

                            <td><?= $sno; ?>.</td>

                            <td>

                                <strong>{{ $partners->partner_name }}</strong>

                            </td>

                            <td>

                                <ul class="list-unstyled users-list m-0 avatar-group d-flex align-items-center">

                                    <li data-bs-toggle="tooltip" data-popup="tooltip-custom" data-bs-placement="top" class="avatar avatar-md pull-up" title="{{ $partners->partner_name }}" >

                                        <img src="{{ asset('storage/' . $partners->partner_image) }}" alt="Partner_Image" class="rounded-circle" />

                                    </li>

                                </ul>

                            </td>

                            <td>{{ $partners->country_name }}</td>

                            {{-- <td>

                                @php
                                    $url = $partners->partner_link;
                                    if (!preg_match("~^(?:f|ht)tps?://~i", $url)) {
                                        $url = "https://" . $url;
                                    }
                                @endphp

                                <a href="{{ $url }}" target="_blank" rel="noopener noreferrer">

                                    <small><strong>{{ $partners->partner_name }}</strong></small>

                                </a>

                            </td> --}}

                            <td>{{ $partners->position_order }}</td>

                            <td>

                                <div class="form-check form-switch mb-2">

                                    <input class="form-check-input status_button" onclick="change_status('<?= $model; ?>', <?= $sno; ?>, '<?= $partners->encrypted_id; ?>');" type="checkbox" id="status<?= $sno; ?>" <?= $partners->status == 'active' ? 'checked' : ''; ?> />

                                </div>

                            </td>

                            <td>

                                <div class="dropdown">

                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">

                                        <i class="bx bx-dots-vertical-rounded"></i>

                                    </button>

                                    <div class="dropdown-menu">

                                        <a class="dropdown-item" href="{{ route('edit.partner', $partners->encrypted_id) }}" >

                                            <i class="bx bx-edit-alt me-1"></i> Edit

                                        </a>

                                        <button class="dropdown-item" onclick="delete_item('<?= $model; ?>', '<?= $partners->encrypted_id; ?>');" >

                                            <i class="bx bx-trash me-1"></i> Delete

                                        </button>

                                    </div>

                                </div>

                            </td>

                        </tr>

                        <?php $sno++; ?>

                        @endforeach

                    </tbody>

                </table>

            </div>

        </div>

        <!--/ Hoverable Table rows -->



    </div>



</div>



@endsection

