@extends('admin.admin-layouts.main-layout')
<?php if(!empty($doctor)) {
    $title = "Edit Doctor";
} else {
    $title = "Add Doctor";
}
?>
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($doctor) ? route('edit.doctor', $doctor->encrypted_id) : route('add.doctor') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_doctors') }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6">
                                    <label for="position_order" class="form-label">Doctor Position</label>
                                    <input type="text" class="form-control" id="position_order" oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($doctor) ? $doctor->position_order : '' }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="hospital" class="form-label">Doctor's Hospital</label>
                                    @php $create = true; @endphp
                                    <select name="hospital" id="hospital" class="form-control">
                                        @foreach($hospitalsData as $hospitals)
                                            @if(!empty($doctor))
                                            <option value="{{ $hospitals->encrypted_id }}" {{ ($doctor->hospital_id == $hospitals->id) ? "selected" : "" }}>{{ $hospitals->hospital_name }}</option>
                                            @else
                                                @if($create == true)
                                                <option value="" selected>--- Select Hospital ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $hospitals->encrypted_id }}">{{ $hospitals->hospital_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('hospital')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="category" class="form-label">Doctor Category</label>
                                    @php $create = true; @endphp
                                    <select name="category" id="category" class="form-control">
                                        @foreach($categoriesData as $categories)
                                            @if(!empty($doctor))
                                            <option value="{{ $categories->encrypted_id }}" {{ ($doctor->category_id == $categories->id) ? "selected" : "" }}>{{ $categories->category_name }}</option>
                                            @else
                                                @if($create == true)
                                                <option value="" selected>--- Select Category ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $categories->encrypted_id }}">{{ $categories->category_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('category')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="doctor_name" class="form-label">Doctor Name</label>
                                    <input type="text" class="form-control" id="doctor_name" name="doctor_name" value="{{ !empty($doctor) ? $doctor->doctor_name : '' }}" onblur="getUrl(this.id);" placeholder="Enter Name" />
                                    @error('doctor_name')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="doctor_link" class="form-label">Doctor URL</label>
                                    <input type="text" class="form-control" id="doctor_link" name="doctor_link" value="{{ !empty($doctor) ? $doctor->doctor_link : '' }}" placeholder="Enter URL" />
                                    @error('doctor_link')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="doctor_phone" class="form-label">Doctor Phone</label>
                                    <input type="text" class="form-control" id="doctor_phone" name="doctor_phone" value="{{ !empty($doctor) ? $doctor->doctor_phone : '' }}" placeholder="Enter Phone Number" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="doctor_email" class="form-label">Doctor E-Mail</label>
                                    <input type="text" class="form-control" id="doctor_email" name="doctor_email" value="{{ !empty($doctor) ? $doctor->doctor_email : '' }}" placeholder="Enter E-Mail" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="city" class="form-label">Doctor City</label>
                                    @php $create = true; @endphp
                                    <select name="city" id="city" class="form-control">
                                        @foreach($citiesData as $cities)
                                            @if(!empty($doctor))
                                            <option value="{{ $cities->encrypted_id }}" {{ ($doctor->city_id == $cities->id) ? "selected" : "" }}>{{ $cities->city_name }}</option>
                                            @else
                                                @if($create == true)
                                                <option value="" selected>--- Select City ---</option>
                                                @php $create = false; @endphp
                                                @endif
                                            <option value="{{ $cities->encrypted_id }}">{{ $cities->city_name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @error('city')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-sm-6">
                                    <label for="designation" class="form-label">Designation</label>
                                    <input type="text" class="form-control" id="designation" name="designation" value="{{ !empty($doctor) ? $doctor->designation : '' }}" placeholder="Enter Designation" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="experience" class="form-label">Experiences</label>
                                    <input type="text" class="form-control" id="experience" name="experience" value="{{ !empty($doctor) ? $doctor->experience : '' }}" placeholder="Enter Experiences" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="educations" class="form-label">Educations</label>
                                    <input type="text" class="form-control" id="educations" name="educations" value="{{ !empty($doctor) ? $doctor->educations : '' }}" placeholder="Enter Educations" />
                                </div>
                                <div class="col-sm-12">
                                    <label for="educations_trainings" class="form-label">Experiences In ( Courses )</label>
                                    <textarea name="educations_trainings" id="educations_trainings" cols="30" rows="5" class="form-control" placeholder="Enter Educations and Trainings" >{{ !empty($doctor) ? htmlspecialchars_decode($doctor->educations_trainings) : '' }}</textarea>
                                </div>
                                <div class="col-sm-12">
                                    <label for="description" class="form-label">Description</label>
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ !empty($doctor) ? htmlspecialchars_decode($doctor->description) : '' }}</textarea>
                                </div>
                                <div class="col-sm-6">
                                    <label for="meta_title" class="form-label">Meta Title</label>
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ !empty($doctor) ? $doctor->meta_title : '' }}" placeholder="Enter Meta Title" />
                                </div>
                                <div class="col-sm-6">
                                    <label for="meta_keyword" class="form-label">Meta Keyword</label>
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="{{ !empty($doctor) ? $doctor->meta_keyword : '' }}" placeholder="Enter Meta Keyword" />
                                </div>
                                <div class="col-sm-12">
                                    <label for="meta_description" class="form-label">Meta Description</label>
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" >{{ !empty($doctor) ? htmlspecialchars_decode($doctor->meta_description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card">
                                <div class="card-body row">
                                    <label for="doctor_image" class="col-sm-3 col-form-label">Doctor Image</label>
                                    <div class="col-sm-9">
                                        @if(!empty($doctor))
                                        <div class="my-3">
                                            <img src="{{ asset('storage/' . $doctor->doctor_image) }}" alt="Doctor_Image" class="rounded" height="50px" width="50px">
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="doctor_image" name="doctor_image" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="{{ !empty($doctor) ? 'Update Doctor' : 'Add Doctor' }}" class="btn btn-primary" />
                        <a href="{{ route('manage_doctors') }}" class="btn btn-outline-secondary">Back</a>
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

<script>

    function getUrl(id) {
        let doctor_name = $.trim($("#"+id).val());
        let doctor_url = doctor_name.replace(/\s+/g, '-').toLowerCase();
        $("#doctor_link").val(doctor_url);
    }

</script>

@endsection
