@extends('admin.admin-layouts.main-layout')
@php
    if(!empty($category)) {
        $title = "Edit Category";
    }
    else {
        $title = "Add Category";
    }
@endphp
@section('title', $title)

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ !empty($category) ? route('edit.category', ["type" => $type, "category" => $category->encrypted_id]) : route('add.category', $type) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header"><?= $title; ?><span class="float-end"><a href="{{ route('manage_categories', $type) }}" class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt' style="font-size: 1.7rem;"></i></a></span></h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="row mb-3">
                                <label for="position_order" class="col-sm-3 col-form-label">Category Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ !empty($category) ? $category->position_order : '' }}" placeholder="Enter Position" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="category_name" class="col-sm-3 col-form-label">Category Name</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="category_name" name="category_name" value="{{ !empty($category) ? $category->category_name : '' }}" onblur="getUrl(this.id)" placeholder="Enter Name" />
                                </div>
                            </div>
                            @if($type == 'doctors')
                            <div class="row mb-3">
                                <label for="link" class="col-sm-3 col-form-label">Category URL</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="link" name="link" value="{{ !empty($category) ? $category->link : '' }}" placeholder="Enter URL" />
                                </div>
                            </div>
                            @endif
                            <div class="row mb-3">
                                <label for="meta_title" class="col-sm-3 col-form-label">Meta Title</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="meta_title" name="meta_title" value="{{ !empty($category) ? $category->meta_title : '' }}" placeholder="Enter Meta Title" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="meta_keyword" class="col-sm-3 col-form-label">Meta Keyword</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="meta_keyword" name="meta_keyword" value="{{ !empty($category) ? $category->meta_keyword : '' }}" placeholder="Enter Meta Keyword" />
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="meta_description" class="col-sm-3 col-form-label">Meta Description</label>
                                <div class="col-sm-9">
                                    <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control" placeholder="Enter Meta Description" >{{ !empty($category) ? htmlspecialchars_decode($category->meta_description) : '' }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="submit" value="{{ !empty($category) ? "Update Category" : "Add Category" }}" class="btn btn-primary" />
                    <a href="{{ route('manage_categories', $type) }}" class="btn btn-outline-secondary">Back</a>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

<script>

    function getUrl(id) {
        let category_name = $.trim($("#"+id).val());
        let link = category_name.replace(/\s+/g, '-').toLowerCase();
        $("#link").val(link);
    }

</script>

@endsection
