<div class="col-md-6 col-lg-4 order-1 mb-4">
    <div class="card h-100">
        <div class="card-header">
            <ul class="nav nav-pills" role="tablist" id="fileTabs">
                <li class="nav-item">
                    <button type="button" class="nav-link active uploaded-tab" data-bs-toggle="tab"
                        data-bs-target="#tab-uploaded">
                        Uploaded
                    </button>
                </li>
                <li class="nav-item">
                    <button type="button" class="nav-link downloaded-tab" data-bs-toggle="tab"
                        data-bs-target="#tab-downloaded">
                        Downloaded
                    </button>
                </li>
                <li class="nav-item">
                    <button type="button" class="nav-link partial-tab" data-bs-toggle="tab"
                        data-bs-target="#tab-partial">
                        Partial
                    </button>
                </li>
                <li class="nav-item">
                    <button type="button" class="nav-link expired-tab" data-bs-toggle="tab"
                        data-bs-target="#tab-expired">
                        Expired
                    </button>
                </li>
            </ul>
        </div>

        <div class="card-body px-0">
            <div class="tab-content p-0">
                <!-- Uploaded -->
                <div class="tab-pane fade show active" id="tab-uploaded">
                    <div class="d-flex p-4 pt-3 align-items-center">
                        <div class="avatar flex-shrink-0 me-3">
                            <i class="bx bx-upload fs-3 text-primary"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Uploaded Files</small>
                            <h5 class="mb-0" id="uploadedCount">0</h5>
                        </div>
                    </div>
                    <div id="uploadedFilesChart"></div>
                    <div class="d-flex justify-content-center pt-4 gap-2">
                        <div class="flex-shrink-0">
                            <div id="weeklyUploadedChart" style="height: 120px;"></div>
                        </div>
                        <div>
                            <p class="mb-n1 mt-1">Uploaded This Week</p>
                            <small class="text-muted" id="weeklyUploadedChangeText">Loading...</small>
                        </div>
                    </div>
                </div>

                <!-- Downloaded -->
                <div class="tab-pane fade" id="tab-downloaded">
                    <div class="d-flex p-4 pt-3 align-items-center">
                        <div class="avatar flex-shrink-0 me-3">
                            <i class="bx bx-download fs-3 text-success"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Downloaded Files</small>
                            <h5 class="mb-0" id="downloadedCount">0</h5>
                        </div>
                    </div>
                    <div id="downloadedFilesChart"
                        style="height: 120px; display: flex; align-items: center; justify-content: center; color: #6c757d; font-size: 14px;">
                        Loading...</div>
                </div>

                <!-- Partially Downloaded -->
                <div class="tab-pane fade" id="tab-partial">
                    <div class="d-flex p-4 pt-3 align-items-center">
                        <div class="avatar flex-shrink-0 me-3">
                            <i class="bx bx-transfer fs-3 text-warning"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Partially Downloaded Files</small>
                            <h5 class="mb-0" id="partialDownloadedFilesCount">0</h5>
                        </div>
                    </div>
                    <div id="partialDownloadedFilesChart"
                        style="height: 120px; display: flex; align-items: center; justify-content: center; color: #6c757d; font-size: 14px;">
                        Loading...</div>
                </div>

                <!-- Expired -->
                <div class="tab-pane fade" id="tab-expired">
                    <div class="d-flex p-4 pt-3 align-items-center">
                        <div class="avatar flex-shrink-0 me-3">
                            <i class="bx bx-block fs-3 text-danger"></i>
                        </div>
                        <div>
                            <small class="text-muted d-block">Expired Files</small>
                            <h5 class="mb-0" id="expiredFilesCount">0</h5>
                        </div>
                    </div>
                    <div id="expiredFilesChart"
                        style="height: 120px; display: flex; align-items: center; justify-content: center; color: #6c757d; font-size: 14px;">
                        Loading...</div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('admin.ajax.uploaded-files-chart')
@include('admin.ajax.downloaded-files-chart')
@include('admin.ajax.partially-downloaded-files-chart')
@include('admin.ajax.expired-files-chart')
