@extends('admin.admin-layouts.main-layout')
@section('title', 'Edit Blog-Content')

@section('content')
<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->

    <div class="container-xxl flex-grow-1 container-p-y">
        <form action="{{ route('edit.blog.content') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <!-- Hoverable Table rows -->
            <h5 class="card-header">Edit Blog-Content</h5>
            <div class="row">
                <div class="col-md-9 mx-auto">
                    @if (session('error'))
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @elseif (session('success'))
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                    @endif
                    <div class="card mb-4">
                        <div class="card-body">
                            {{-- <div class="mb-3 row">
                                <label for="position_order" class="col-sm-3 col-form-label">Blog-Content Position</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="position_order"  oninput="this.value = this.value.replace(/[^0-9.]/g, '').replace(/(\..*?)\..*/g, '$1').replace(/^0[^.]/, '0');" maxlength="2" name="position_order" value="{{ $blog_content->position_order }}" placeholder="Enter Position" />
                                    @error('position_order')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div> --}}
                            <div class="mb-3 row">
                                <label for="content_headline" class="col-sm-3 col-form-label">Blog-Content Headline</label>
                                <div class="col-sm-9">
                                    <input type="text" class="form-control" id="content_headline" name="content_headline" value="{{ $blog_content->content_headline }}" placeholder="Enter Headline" />
                                    {{-- onblur="getUrl(this.id)" --}}
                                    @error('content_headline')
                                        <div class="text-danger">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="row mb-3">
                                <label for="description" class="col-sm-3 col-form-label">Description</label>
                                <div class="col-sm-9">
                                    <textarea name="description" id="description" cols="30" rows="5" class="form-control" placeholder="Enter Description" >{{ htmlspecialchars_decode($blog_content->description) }}</textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="content_image" class="col-sm-3 col-form-label">Blog-Content Image</label>
                                    <div class="col-sm-9">
                                        <div class="my-3">
                                            <img src="{{ asset('storage/' . $blog_content->content_image) }}" alt="Blog_Content_Image" class="rounded" height="50px" width="50px">
                                        </div>
                                        <input class="form-control" type="file" id="content_image" name="content_image" />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="demo-inline-spacing">
                        <input type="submit" value="Update Blog-Content" class="btn btn-primary" />
                    </div>
                </div>
            </div>
            <!--/ Hoverable Table rows -->
        </form>
    </div>
</div>

{{-- <script>

    function getUrl(id) {
        let blog_headline = $.trim($("#"+id).val());
        let blog_link = blog_headline.replace(/\s+/g, '-').toLowerCase();
        $("#blog_link").val(blog_link);
    }

</script> --}}

@endsection
