@extends('admin.layouts.blog-layout')
<?php if (!empty($blog->encrypted_id)) {
    $title = 'Edit Blog';
} else {
    $title = 'Add Blog';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form action="{{ !empty($blog->encrypted_id) ? route('edit.blog', $blog->encrypted_id) : route('add.blog') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.blogs') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="blog_headline" class="col-form-label">Blog Headline</label>
                                        <input type="text" class="form-control" id="blog_headline" name="blog_headline"
                                            value="{{ !empty($blog->encrypted_id) ? $blog->blog_headline : '' }}"
                                            placeholder="Enter Headline" onblur="getUrl(this.id)" />
                                        @error('blog_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="blog_url" class="col-form-label">Blog URL</label>
                                        <input type="text" class="form-control" id="blog_url" name="blog_url"
                                            value="{{ !empty($blog->encrypted_id) ? $blog->blog_url : '' }}"
                                            placeholder="Enter URL" />
                                        @error('blog_url')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="blog_category" class="form-label">Blog Category</label>
                                        <select name="blog_category" id="blog_category" class="form-select">
                                            <option value="">-- Select Category --</option>
                                            @if (!empty($blog->encrypted_id))
                                                <option value="development"
                                                    {{ $blog->blog_category == 'development' ? 'selected' : '' }}>
                                                    Development</option>
                                                <option value="design"
                                                    {{ $blog->blog_category == 'design' ? 'selected' : '' }}>Design</option>
                                            @else
                                                <option value="development">Development</option>
                                                <option value="design">Design</option>
                                            @endif
                                        </select>
                                        @error('blog_category')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="post_date" class="col-form-label">Post Date</label>
                                        <input type="date" class="form-control" id="post_date" name="post_date"
                                            value="{{ !empty($blog->encrypted_id) ? date('Y-m-d', strtotime($blog->post_date)) : '' }}"
                                            placeholder="Enter Date" />
                                        @error('post_date')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-12">
                                        <label for="short_description" class="col-form-label">Short Description</label>
                                        <textarea id="short_description" name="short_description" class="form-control" placeholder="Enter Short Description">{{ !empty($blog->encrypted_id) ? htmlspecialchars_decode($blog->short_description) : '' }}</textarea>
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea id="description" name="description" class="form-control" placeholder="Enter Description">{{ !empty($blog->encrypted_id) ? htmlspecialchars_decode($blog->description) : '' }}</textarea>
                                    </div>
                                    <div class="col-6">
                                        <label for="written_by" class="col-form-label">Written By</label>
                                        <input type="text" class="form-control" id="written_by" name="written_by"
                                            value="{{ !empty($blog->encrypted_id) ? $blog->written_by : '' }}"
                                            placeholder="Enter Written By" />
                                        @error('written_by')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    {{--
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_instagram" class="col-form-label">Writer Instagram URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_instagram" name="writer_instagram" value="{{ !empty($blog->encrypted_id) ? $blog->writer_instagram : '' }}" placeholder="Enter Instagram URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_linkedin" class="col-form-label">Writer LinkedIn URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_linkedin" name="writer_linkedin" value="{{ !empty($blog->encrypted_id) ? $blog->writer_linkedin : '' }}" placeholder="Enter LinkedIn URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_x" class="col-form-label">Writer X URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_x" name="writer_x" value="{{ !empty($blog->encrypted_id) ? $blog->writer_x : '' }}" placeholder="Enter X URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_facebook" class="col-form-label">Writer Facebook URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_facebook" name="writer_facebook" value="{{ !empty($blog->encrypted_id) ? $blog->writer_facebook : '' }}" placeholder="Enter Facebook URL" />-->
                                <!--</div>-->
                                <!--<div class="col-6">-->
                                <!--    <label for="writer_threads" class="col-form-label">Writer Instagram Threads URL</label>-->
                                <!--    <input type="text" class="form-control" id="writer_threads" name="writer_threads" value="{{ !empty($blog->encrypted_id) ? $blog->writer_threads : '' }}" placeholder="Enter Instagram Threads URL" />-->
                                <!--</div>-->
                                --}}
                                    <div class="col-6">
                                        <label for="meta_title" class="col-form-label">Meta Title</label>
                                        <input type="text" class="form-control" id="meta_title" name="meta_title"
                                            value="{{ !empty($blog->encrypted_id) ? $blog->meta_title : '' }}"
                                            placeholder="Enter Meta Title" />
                                    </div>
                                    <div class="col-6">
                                        <label for="meta_keyword" class="col-form-label">Meta Keyword</label>
                                        <input type="text" class="form-control" id="meta_keyword" name="meta_keyword"
                                            value="{{ !empty($blog->encrypted_id) ? $blog->meta_keyword : '' }}"
                                            placeholder="Enter Meta Keyword" />
                                    </div>
                                    <div class="col-12">
                                        <label for="meta_description" class="col-form-label">Meta Description</label>
                                        <textarea name="meta_description" id="meta_description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Meta Description">{{ !empty($blog->encrypted_id) ? htmlspecialchars_decode($blog->meta_description) : '' }}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="blog_image" class="col-form-label">Blog Image</label>
                                        @if (!empty($blog->encrypted_id) && !empty($blog->blog_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($blog->blog_image) }}" alt="Blog_Image"
                                                    class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="blog_image" name="blog_image"
                                            accept="image/*" />
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <label for="writer_image" class="col-form-label">Writer Image</label>
                                        @if (!empty($blog->encrypted_id) && !empty($blog->writer_image))
                                            <div style="display: inline-block; position: relative; margin: 30px;"
                                                class="my-3">
                                                <img src="{{ asset($blog->writer_image) }}" alt="Writer_Image"
                                                    class="rounded" height="60px" width="60px"
                                                    style="object-fit: cover;">
                                                <button
                                                    style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                            </div>
                                        @endif
                                        <input class="form-control" type="file" id="writer_image" name="writer_image"
                                            accept="image/*" />
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{--
                    <!--<h5 class="card-header mb-3">Section Management</h5>-->
                    <!--<div id="all-sections"></div>-->
                    <!--<span class="float-end"><button type="button" id="add-section" class="btn rounded-pill btn-icon btn-primary float-end" style="font-size: 1.7em;">+</button></span>-->
                    --}}
                        <div class="demo-inline-spacing">
                            <input type="submit" value="{{ !empty($blog->encrypted_id) ? 'Update Blog' : 'Add Blog' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.blogs') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>
    <script>
        function getUrl(field_id) {
            let errors = 0;
            let blog_headline = $.trim($("#" + field_id).val());
            let id = "{{ !empty($blog->encrypted_id) ? $blog->encrypted_id : '' }}";

            // Replace '/' and spaces with '-'
            let blog_url = blog_headline.replace(/[\/\s]+/g, '-').toLowerCase();

            if (blog_headline == "" || blog_headline == undefined || blog_headline == null) {
                errors += 1;
            }
            if (blog_url == "" || blog_url == undefined || blog_url == null) {
                errors += 1;
            }

            if (errors > 0) {
                $("#blog_url").val("");
                return false;
            } else {
                // Remove invalid characters, trim extra dashes, and replace multiple dashes with a single dash
                blog_url = blog_url.replace(/[^a-z0-9-]+/g, '-').replace(/-+/g, '-').replace(/^-+|-+$/g, '');

                // Use Blade to generate the base route and append parameters dynamically
                let url = "{{ route('check.blog.link', ['blog_url' => '__LINK__', 'id' => '__ID__']) }}"
                    .replace('__LINK__', blog_url)
                    .replace('__ID__', id);

                // Send GET request with parameters in the URL
                fetch(url)
                    .then(response => response.text()) // Expecting plain text response
                    .then(data => {
                        document.getElementById("blog_url").value = data; // Update input field with returned link
                        // $("#blog_url").val(data);
                    })
                    .catch(error => console.error("Error:", error));
            }
        }
    </script>

    {{--
<script>
    // document.addEventListener('DOMContentLoaded', function () {
    //     let rowCount = 1;

    //     // Function to add a new row
    //     function addRow(item = {}) {

    //         // Create the main card div
    //         const card = document.createElement('div');
    //         card.className = 'card mb-4';
    //         card.id = `row-${rowCount}`;
            
    //         // Create the card body
    //         const cardBody = document.createElement('div');
    //         cardBody.className = 'card-body';
            
    //         // -------------------------------------- Hidden input for ID -----------------------------------------
    //         const idInput = document.createElement('input');
    //         idInput.type = 'hidden';
    //         idInput.name = 'section[]';
    //         idInput.value = item.section_id || '';
    //         cardBody.appendChild(idInput);
            
    //         // ------------------------------------- Create the row (Section Title & Section Headline) ------------------------------------------
    //         const row1 = document.createElement('div');
    //         row1.className = 'row mb-3';
            
    //         // -------------------------- Section Title column ------------------------------
    //         const col1 = document.createElement('div');
    //         col1.className = 'col-6';

    //         // ----------- Label ------------
    //         const label1 = document.createElement('label');
    //         label1.htmlFor = `sectionTitles-${rowCount}`;
    //         label1.className = 'col-form-label';
    //         label1.textContent = 'Section Title';
            
    //         // ----------- Input field ------------
    //         const input1 = document.createElement('input');
    //         input1.type = 'text';
    //         input1.className = 'form-control';
    //         input1.id = `sectionTitles-${rowCount}`;
    //         input1.name = 'section_titles[]';
    //         input1.placeholder = 'Enter Title';
    //         input1.value = item.section_title || '';

    //         // Prevent removal of the required attribute
    //         Object.defineProperty(input1, 'required', {
    //             configurable: false,
    //             writable: false,
    //             value: true,
    //         });
            
    //         // -------------------------- Section Headline column ------------------------------
    //         const col11 = document.createElement('div');
    //         col11.className = 'col-6';
            
    //         // --------------- Label -------------------
    //         const label11 = document.createElement('label');
    //         label11.htmlFor = `sectionHeadlines-${rowCount}`;
    //         label11.className = 'col-form-label';
    //         label11.textContent = 'Section Headline';
            
    //         // ----------- Input field ------------
    //         const input11 = document.createElement('input');
    //         input11.type = 'text';
    //         input11.className = 'form-control';
    //         input11.id = `sectionHeadlines-${rowCount}`;
    //         input11.name = 'section_headlines[]';
    //         input11.placeholder = 'Enter Headline';
    //         input11.value = item.section_headline || '';
    //         input11.required = true;
            
    //         // Prevent removal of the required attribute
    //         Object.defineProperty(input11, 'required', {
    //             configurable: false,
    //             writable: false,
    //             value: true,
    //         });
            
    //         // -------------- Append input to column and label + column to row (Section Title & Section Headline) -----------------------
    //         col1.appendChild(label1);
    //         col1.appendChild(input1);
    //         col11.appendChild(label11);
    //         col11.appendChild(input11);
    //         row1.appendChild(col1);
    //         row1.appendChild(col11);
            
    //         // ------------------------------------- Create the row (Description) ------------------------------------------
    //         const row2 = document.createElement('div');
    //         row2.className = 'row mb-3';

    //         // -------------------------- Description column ------------------------------
    //         const col2 = document.createElement('div');
    //         col2.className = 'col-12';
            
    //         // --------------- Label -------------------
    //         const label2 = document.createElement('label');
    //         label2.htmlFor = `descriptions-${rowCount}`;
    //         label2.className = 'col-form-label';
    //         label2.textContent = 'Description';
            
    //         // ----------- Textarea field ------------
    //         const textarea1 = document.createElement('textarea');
    //         textarea1.id = `descriptions-${rowCount}`;
    //         textarea1.name = 'descriptions[]';
    //         textarea1.cols = 30;
    //         textarea1.rows = 5;
    //         textarea1.className = 'text-area form-control';
    //         textarea1.placeholder = 'Enter Description';
    //         textarea1.textContent = item.description || '';
            
    //         // -------------- Append input to column and label + textarea to row (Description) -----------------------
    //         row2.appendChild(label2);
    //         col2.appendChild(textarea1);
    //         row2.appendChild(col2);
            
    //         // ------------------------------------- Create the row (File Input) ------------------------------------------
    //         const fileInputWrapper = document.createElement('div');
    //         fileInputWrapper.classList.add('row', 'mb-3');
            
    //         // -------------------------- File Input column ------------------------------
    //         const fileInputCol = document.createElement('div');
    //         fileInputCol.classList.add('col-6');

    //         // --------------- Label -------------------
    //         const fileInputLabel = document.createElement('label');
    //         fileInputLabel.textContent = 'Section Image';
    //         fileInputLabel.htmlFor = `sectionImages-${rowCount}`;
    //         fileInputCol.appendChild(fileInputLabel);

    //         // ----------- File Input field ------------
    //         const fileInput = document.createElement('input');
    //         fileInput.type = 'file';
    //         fileInput.id = `sectionImages-${rowCount}`;
    //         fileInput.name = 'section_images[]';
    //         fileInput.accept = 'image/*';
    //         fileInput.classList.add('form-control', 'image-input');
    //         fileInput.setAttribute('data-id', rowCount); // Store row ID for preview

    //         // -------------- Append input to column and label + File Input to row (File Input) -----------------------
    //         fileInputCol.appendChild(fileInput);
    //         fileInputWrapper.appendChild(fileInputCol);
            
    //         // -------------------------- File Preview column ------------------------------
    //         const filePreviewColumn = document.createElement('div');
    //         filePreviewColumn.classList.add('col-6');
            
    //         // // Container for Image Previews
    //         // const imgPreviewContainer = document.createElement('div');
    //         // imgPreviewContainer.id = `image-preview-container-${rowCount}`; // Unique container ID
    //         // imgPreviewContainer.classList.add('image-preview-container');
    //         // fileInputWrapper.appendChild(imgPreviewContainer);

    //         // Clear previous previews
    //         filePreviewColumn.innerHTML = '';

    //         // Event Listener for File Input or Existing Images
    //         if(item.section_images) {
    //             const file = item.section_images; // Assuming 'item.section_images' contains existing file names

    //             // Container for Image and Remove Button
    //             const previewWrapper = document.createElement('div');
    //             previewWrapper.style.display = 'inline-block';
    //             previewWrapper.style.position = 'relative';
    //             previewWrapper.style.margin = '5px';

    //             // Create Image Preview Element
    //             const imgPreview = document.createElement('img');
    //             imgPreview.style.cssText = `
    //                 width: 50px;
    //                 height: 50px;
    //                 object-fit: cover;
    //             `;
    //             imgPreview.src = `{{ asset('${file}') }}`;

    //             // Create Remove Button
    //             const removeImageButton = document.createElement('button');
    //             removeImageButton.innerHTML = '&times;'; // "X" for close
    //             removeImageButton.style.cssText = `
    //                 position: absolute;
    //                 top: -5px;
    //                 right: -5px;
    //                 width: 20px;
    //                 height: 20px;
    //                 background: red;
    //                 color: white;
    //                 border: none;
    //                 border-radius: 50%;
    //                 font-size: 14px;
    //                 cursor: pointer;
    //             `;

    //             // Remove Button Click Event
    //             removeImageButton.onclick = function () {
    //                 previewWrapper.remove(); // Remove the image preview container
    //                 console.log(`Removed image: ${file}`);
    //             };

    //             // Append Image and Remove Button to Wrapper
    //             previewWrapper.appendChild(imgPreview);
    //             previewWrapper.appendChild(removeImageButton);

    //             // Append Wrapper to the Container
    //             filePreviewColumn.appendChild(previewWrapper);
    //         }


    //         // // Loop through selected files and create previews with remove buttons
    //         // if (files != null && files != undefined) {
    //         //     if (files[0].length > 0) {
    //         //         Array.from(files).forEach((file) => {
    //         //             // Container for Image and Remove Button
    //         //             const previewWrapper = document.createElement('div');
    //         //             previewWrapper.style.display = 'inline-block';
    //         //             previewWrapper.style.position = 'relative';
    //         //             previewWrapper.style.margin = '5px';

    //         //             // Create Image Preview Element
    //         //             const imgPreview = document.createElement('img');
    //         //             imgPreview.style.cssText = `
    //         //                 width: 50px;
    //         //                 height: 50px;
    //         //                 object-fit: cover;
    //         //             `;
    //         //             imgPreview.src = "{{ asset('"+file+"') }}";

    //         //             // Create Remove Button
    //         //             const removeButton = document.createElement('button');
    //         //             removeButton.innerHTML = '&times;'; // "X" for close
    //         //             removeButton.style.cssText = `
    //         //                 position: absolute;
    //         //                 top: -5px;
    //         //                 right: -5px;
    //         //                 width: 20px;
    //         //                 height: 20px;
    //         //                 background: red;
    //         //                 color: white;
    //         //                 border: none;
    //         //                 border-radius: 50%;
    //         //                 font-size: 14px;
    //         //                 cursor: pointer;
    //         //             `;

    //         //             // Remove Button Click Event
    //         //             removeButton.onclick = function () {
    //         //                 previewWrapper.remove(); // Remove the image preview container
    //         //                 console.log(`Removed image: ${file}`);
    //         //             };

    //         //             // Append Image and Remove Button to Wrapper
    //         //             previewWrapper.appendChild(imgPreview);
    //         //             previewWrapper.appendChild(removeButton);

    //         //             // Append Wrapper to the Container
    //         //             imgPreviewContainer.appendChild(previewWrapper);
    //         //         });
    //         //     }
    //         // }

    //         // Append Image Preview Container
    //         // filePreviewColumn.appendChild(imgPreviewContainer);
    //         fileInputWrapper.appendChild(filePreviewColumn);

    //         const buttonsDiv = document.createElement('div');
    //         buttonsDiv.classList.add('float-end');

    //         // // Add Button
    //         // const addButton = document.createElement('button');
    //         // addButton.type = 'button';
    //         // addButton.classList.add('btn', 'btn-primary', 'btn-icon', 'rounded-pill', 'me-1');
    //         // addButton.style.fontSize = '1.7em';
    //         // addButton.innerHTML = `+`;
    //         // addButton.onclick = function () {
    //         //     addRow();
    //         // };
            
    //         // Remove Button
    //         const removeButton = document.createElement('button');
    //         removeButton.type = 'button';
    //         removeButton.classList.add('btn', 'btn-danger', 'btn-icon', 'rounded-pill');
    //         removeButton.innerHTML = `<i class="bx bx-trash"></i>`;
    //         removeButton.onclick = function () {
    //             if(item.section_id != "" && item.section_id != undefined && item.section_id != null) {
    //                 $.ajax({
    //                     url: "{{ route('delete.blog.section') }}",
    //                     method: "POST",
    //                     data: {"_token": '{{ csrf_token() }}', 'section': item.section_id},
    //                     success: function(res) {
    //                         card.remove();
    //                     }
    //                 });
    //             }
    //             else {
    //                 card.remove();
    //             }
    //         };

    //         // buttonsDiv.appendChild(addButton);
    //         buttonsDiv.appendChild(removeButton);
            
    //         // Append rows to card body
    //         cardBody.appendChild(buttonsDiv);
    //         cardBody.appendChild(row1);
    //         cardBody.appendChild(row2);
    //         cardBody.appendChild(fileInputWrapper);
            
    //         // Append card body to card
    //         card.appendChild(cardBody);

    //         // Append the new row to the form
    //         document.getElementById('all-sections').appendChild(card);
            
    //         // Initialize TinyMCE for the newly created textarea
    //         tinymce.init({
    //             selector: `.text-area`, // Target the newly created textarea by its ID
    //             plugins: 'a11ychecker advcode advlist advtable anchor autocorrect autolink autoresize autosave casechange charmap checklist code codesample directionality editimage emoticons export footnotes formatpainter fullscreen help image importcss inlinecss insertdatetime link linkchecker lists media mediaembed mentions mergetags nonbreaking pagebreak pageembed permanentpen powerpaste preview quickbars save searchreplace table tableofcontents template tinycomments tinydrive tinymcespellchecker typography visualblocks visualchars wordcount',
    //             toolbar: 'undo redo | blocks| bold italic | bullist numlist checklist | code | table | alignleft aligncenter alignright alignjustify | outdent indent | wordcount | a11ycheck advtablerownumbering typopgraphy anchor restoredraft casechange charmap checklist code codesample addcomment showcomments ltr rtl editimage fliph flipv imageoptions rotateleft rotateright emoticons export footnotes footnotesupdate formatpainter fullscreen help image insertdatetime link openlink unlink bullist numlist media mergetags mergetags_list nonbreaking pagebreak pageembed permanentpen preview quickimage quicklink quicktable cancel save searchreplace spellcheckdialog spellchecker',
    //             resize: 'both'
    //         });
            
    //         rowCount++;
    //     }
        
    //     @if (!empty($blog->encrypted_id))

    //     // Fetch data from the server (get_sub_section_data.php) and add rows
    //     fetch("{{ route('get.blog.section', $blog->encrypted_id) }}")
    //         .then(response => response.json())
    //         .then(data => {
    //             data.forEach(item => {
    //                 addRow(item);
    //             });
    //         });

    //     @endif

    //     // Event listener to add a new blank row when "Add Row" button is clicked
    //     document.getElementById('add-section').addEventListener('click', () => {
    //         addRow();
    //     });
    // });
</script>
--}}

    @yield('editor')

@endsection
