@extends('admin.layouts.main-layout')

<?php if (!empty($banner->encrypted_id)) {
    $title = 'Edit Banner';
} else {
    $title = 'Add Banner';
}
?>
@section('title', $title)

@section('content')
    <!-- Content wrapper -->
    <div class="content-wrapper">
        <!-- Content -->
        <div class="container-xxl flex-grow-1 container-p-y">
            <form
                action="{{ !empty($banner->encrypted_id) ? route('edit.banner', $banner->encrypted_id) : route('add.banner') }}"
                method="POST" enctype="multipart/form-data">
                @csrf
                <!-- Hoverable Table rows -->
                <h5 class="card-header"><?= $title ?><span class="float-end"><a href="{{ route('manage.banners') }}"
                            class="btn btn-icon rounded-pill btn-outline-secondary float-end"><i class='bx bx-left-arrow-alt'
                                style="font-size: 1.7rem;"></i></a></span></h5>
                <div class="row">
                    <div class="col-md-12">
                        @if (session('error'))
                            <div class="alert alert-danger alert-dismissible" role="alert">
                                {{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"
                                    aria-label="Close"></button>
                            </div>
                        @endif
                        <div class="card mb-4">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-6">
                                        <label for="banner_headline" class="col-form-label">Banner Headline</label>
                                        <input type="text" class="form-control" id="banner_headline"
                                            name="banner_headline"
                                            value="{{ !empty($banner->encrypted_id) ? $banner->banner_headline : old('banner_headline') }}"
                                            placeholder="Enter Headline" />
                                        @error('banner_headline')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="banner_title" class="col-form-label">Banner Title</label>
                                        <input type="text" class="form-control" id="banner_title" name="banner_title"
                                            value="{{ !empty($banner->encrypted_id) ? $banner->banner_title : old('banner_title') }}"
                                            placeholder="Enter Title" />
                                        @error('banner_title')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-12">
                                        <label for="description" class="col-form-label">Description</label>
                                        <textarea name="description" id="description" cols="30" rows="5" class="form-control"
                                            placeholder="Enter Description">{{ !empty($banner->encrypted_id) ? htmlspecialchars_decode($banner->description) : old('description') }}</textarea>
                                        @error('description')
                                            <div class="text-danger">{{ $message }}</div>
                                        @enderror
                                    </div>
                                    <div class="col-6">
                                        <label for="button_name" class="col-form-label">Button</label>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="button_name" name="button_name"
                                                value="{{ !empty($banner->encrypted_id) ? $banner->button_name : old('button_name') }}"
                                                placeholder="Enter Name" />
                                        </div>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="button_link" name="button_link"
                                                value="{{ !empty($banner->encrypted_id) ? $banner->button_link : old('button_link') }}"
                                                placeholder="Enter Link" />
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <label for="other_button_name" class="col-form-label">Other Button</label>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="other_button_name"
                                                name="other_button_name"
                                                value="{{ !empty($banner->encrypted_id) ? $banner->other_button_name : old('other_button_name') }}"
                                                placeholder="Enter Name" />
                                        </div>
                                        <div class="mb-3">
                                            <input type="text" class="form-control" id="other_button_link"
                                                name="other_button_link"
                                                value="{{ !empty($banner->encrypted_id) ? $banner->other_button_link : old('other_button_link') }}"
                                                placeholder="Enter Link" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="card mb-3">
                                    <div class="card-body row">
                                        <div class="col-12">
                                            <label for="banner_image" class="col-form-label">Banner Image</label>
                                            @if (!empty($banner->encrypted_id) && !empty($banner->banner_image))
                                                <div class="my-3">
                                                    <div style="display: inline-block; position: relative; margin: 5px;">
                                                        <img src="{{ asset($banner->banner_image) }}" alt="Banner_Image"
                                                            class="rounded" height="60px" width="60px"
                                                            style="object-fit: cover;">
                                                        <button
                                                            style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                                    </div>
                                                </div>
                                            @endif
                                            <input class="form-control" type="file" id="banner_image"
                                                name="banner_image" accept="image/*" />
                                            @error('banner_image')
                                                <div class="text-danger">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        {{-- <div class="row">
                        <div class="col-sm-12">
                            <div class="card mb-3">
                                <div class="card-body row">
                                    <label for="banner_icons" class="col-form-label">Banner Icons</label>
                                    <div class="col-sm-9">
                                        @if (!empty($banner->encrypted_id))
                                        <div class="my-3">
                                            @if (!empty($banner->banner_icons))
                                            @php
                                                $banner_icons = json_decode($banner->banner_icons);
                                            @endphp
                                                @foreach ($banner_icons as $icon)
                                                <div style="display: inline-block; position: relative; margin: 5px;">
                                                    <img src="{{ asset($icon->file_path) }}" alt="Banner_Icons" class="rounded" height="60px" width="60px" style="object-fit: cover;">
                                                    <button style="position: absolute; top: -5px; right: -5px; width: 20px; height: 20px; background: red; color: white; border: none; border-radius: 50%; font-size: 14px; cursor: pointer;">×</button>
                                                </div>
                                                @endforeach
                                            @endif
                                        </div>
                                        @endif
                                        <input class="form-control" type="file" id="banner_icons" name="banner_icons[]" accept="image/*" multiple />
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div> --}}
                        <div class="demo-inline-spacing">
                            <input type="submit"
                                value="{{ !empty($banner->encrypted_id) ? 'Update Banner' : 'Add Banner' }}"
                                class="btn btn-primary" />
                            <a href="{{ route('manage.banners') }}" class="btn btn-outline-secondary">Back</a>
                        </div>
                    </div>
                </div>
                <!--/ Hoverable Table rows -->
            </form>
        </div>
    </div>

@endsection
