<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('courses', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('category_id')->index();
            $table->unsignedInteger('position_order');
            $table->string('course_icon', 255)->nullable();
            $table->string('course_name');
            $table->string('course_headline');
            $table->string('course_code');
            $table->decimal('course_duration', 8, 2)->nullable();
            $table->string('course_url')->nullable();
            $table->string('course_category', 255)->nullable();
            $table->longText('short_description')->nullable();
            $table->longText('description')->nullable();
            $table->string('breadcrumb_headline')->nullable();
            $table->string('meta_title')->nullable();
            $table->string('meta_keyword')->nullable();
            $table->longText('meta_description')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('courses');
    }
};
