<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('testimonials', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('position_order');
            $table->unsignedInteger('rating_quantity')->nullable();
            $table->string('client_name', 255)->nullable();
            $table->longText('description')->nullable();
            $table->string('client_image', 255)->nullable();
            $table->string('client_designation', 255)->nullable();
            $table->string('client_city', 255)->nullable();
            $table->date('review_date')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('testimonials');
    }
};
