<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('position_order');
            $table->string('header_footer_name', 255)->nullable();
            $table->string('client_page_urls', 255)->nullable();
            $table->string('visibility', 200)->default('none');
            $table->string('page_name', 200)->nullable();
            $table->string('page_headline', 200)->nullable();
            $table->string('breadcrumb_headline', 200)->nullable();
            $table->string('page_image', 255)->nullable();
            $table->longText('description')->nullable();
            $table->string('meta_title', 255)->nullable();
            $table->string('meta_keyword', 200)->nullable();
            $table->text('meta_description')->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
