<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('banners', function (Blueprint $table) {
            $table->id();
            $table->unsignedInteger('position_order');
            $table->string('banner_headline', 255)->nullable();
            $table->string('banner_title', 255)->nullable();
            $table->longText('description')->nullable();
            $table->string('button_name', 200)->nullable();
            $table->string('button_link', 255)->nullable();
            $table->string('other_button_name', 200)->nullable();
            $table->string('other_button_link', 255)->nullable();
            $table->string('banner_image', 255)->nullable();
            $table->string('banner_icons', 255)->nullable();
            $table->string('status')->default('active');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('banners');
    }
};
