<?php

namespace App\Models;

use App\Models\Admin\Pricing;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class CustomersPlansTransactions extends Model
{
    use HasApiTokens;

    protected $table = 'customers_plans_transactions';

    protected $fillable = ['customer_id', 'plan_id', 'payment_gateway', 'transaction_id', 'gateway_order_id', 'gateway_payment_id', 'gateway_signature', 'amount', 'currency', 'transaction_status', 'payment_details'];

    protected $casts = [
        'payment_details' => 'array',
        'amount' => 'decimal:2',
    ];

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id');
    }

    public function plan()
    {
        return $this->belongsTo(Pricing::class, 'plan_id');
    }
}
