<?php

namespace App\Models;

use App\Models\Admin\Pricing;
use Illuminate\Database\Eloquent\Model;
use Laravel\Sanctum\HasApiTokens;

class CustomersPlans extends Model
{
    use HasApiTokens;

    protected $table = 'customers_plans';

    protected $fillable = ['customer_id', 'plan_id', 'transaction_id', 'invoice_id', 'plan_status', 'start_date', 'expiry_date', 'auto_renew'];

    protected $casts = [
        'start_date' => 'date',
        'expiry_date' => 'date',
        'auto_renew' => 'boolean',
    ];

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id');
    }

    public function plan()
    {
        return $this->belongsTo(Pricing::class, 'plan_id');
    }

    public function invoice()
    {
        return $this->hasOne(CustomersInvoices::class, 'id', 'invoice_id');
    }

    // Relationships
    public function transaction()
    {
        return $this->hasOne(CustomersPlansTransactions::class, 'id', 'transaction_id');
    }
}
