<?php

namespace App\Models;

use App\Models\Admin\Pricing;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CustomersInvoices extends Model
{
    use HasFactory;

    protected $fillable = [
        'transaction_id',
        'customer_id',
        'plan_id',
        'invoice_number',
        'amount',
        'currency',
        'status',
        'pdf_path',
    ];

    public function transaction()
    {
        return $this->belongsTo(CustomersPlansTransactions::class, 'transaction_id');
    }

    public function customer()
    {
        return $this->belongsTo(Customers::class, 'customer_id');
    }

    public function plan()
    {
        return $this->belongsTo(Pricing::class, 'plan_id');
    }
}
