<?php

namespace App\Models;

use App\Notifications\CustomerResetPasswordNotification;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Customers extends Authenticatable
{
    use HasApiTokens, Notifiable;

    protected $table = 'customers';

    protected $fillable = ['name', 'mobile', 'email', 'password', 'plan'];

    protected $hidden = ['password', 'remember_token'];

    public function sendPasswordResetNotification($token)
    {
        $url = env('MAIL_FRONTEND_URL') . '/reset-password/' . $token . '?email=' . urlencode($this->email);
        $this->notify(new CustomerResetPasswordNotification($url));
    }
}
