<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Courses extends Model
{
    use HasFactory;

    protected $table = 'courses';

    protected $fillable = [
        'category_id',
        'position_order',
        'course_icon',
        'course_name',
        'course_headline',
        'course_code',
        'course_duration',
        'course_url',
        'course_category',
        'short_description',
        'description',
        'breadcrumb_headline',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'category_id' => 'integer',
        'position_order' => 'integer',
        'course_icon' => 'string',
        'course_name' => 'string',
        'course_headline' => 'string',
        'course_code' => 'string',
        'course_duration' => 'decimal:2',
        'course_url' => 'string',
        'course_category' => 'string',
        'short_description' => 'string',
        'description' => 'string',
        'breadcrumb_headline' => 'string',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'status' => 'string',
    ];

    public function category()
    {
        return $this->belongsTo(Categories::class, 'category_id', 'id');
    }

    public function assignments()
    {
        return $this->hasMany(Assignments::class, 'course_id', 'id');
    }
}
