<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Coupons extends Model
{
    use HasFactory;

    protected $table = 'coupons';

    protected $fillable = [
        'position_order',
        'reference_type',
        'coupon_name',
        'coupon',
        'coupon_relevant_text',
        'coupon_validity',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'parent_id' => 'integer',
        'position_order' => 'integer',
        'reference_type' => 'string',
        'coupon_name' => 'string',
        'coupon' => 'string',
        'coupon_relevant_text' => 'string',
        'coupon_validity' => 'datetime',
        'status' => 'string',
    ];

    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
