<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Blogs extends Model
{
    use HasFactory;

    protected $table = 'blogs';

    protected $fillable = [
        'position_order',
        'blog_headline',
        'blog_url',
        'blog_category',
        'short_description',
        'description',
        'blog_image',
        'written_by',
        'writer_image',
        'post_date',
        'meta_title',
        'meta_keyword',
        'meta_description',
        'status'
    ];

    protected $casts = [
        'id' => 'integer',
        'position_order' => 'integer',
        'blog_headline' => 'string',
        'blog_url' => 'string',
        'blog_category' => 'string',
        'short_description' => 'string',
        'description' => 'string',
        'blog_image' => 'string',
        'written_by' => 'string',
        'writer_image' => 'string',
        'post_date' => 'date',
        'meta_title' => 'string',
        'meta_keyword' => 'string',
        'meta_description' => 'string',
        'status' => 'string',
    ];
}
