<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Socket\Raw\Factory as SocketFactory;
use Xenolope\Quahog\Client as ClamavClient;

class MalwareScannerController extends Controller
{
    public function __construct(
        private string $host,
        private int $port,
        private int $timeoutSeconds = 10
    ) {}

    public static function make(): self
    {
        return new self(
            host: config('services.clamav.host'),
            port: (int) config('services.clamav.port'),
            timeoutSeconds: (int) config('services.clamav.timeout')
        );
    }

    public function scanStream($resource)
    {
        // $resource is a PHP stream (e.g., UploadedFile::readStream())
        $socket = (new SocketFactory())->createClient("tcp://{$this->host}:{$this->port}");
        $client = new ClamavClient($socket, $this->timeoutSeconds);

        $result = $client->scanStream($resource); // uses INSTREAM
        // $result like: ['filename' => 'stream', 'malware' => false, 'reason' => 'OK']
        return $result;
    }
}
