<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Partners;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class PartnersController extends Controller
{
    public function managePartners()
    {
        $partners = Partners::select('id', 'position_order', 'partner_name', 'partner_image', 'status')->get();
        foreach ($partners as $partner) {
            $partner->encrypted_id = Crypt::encrypt($partner->id);
        }
        $currentPage = "manage_partners";
        $model = Crypt::encrypt('Partners');
        return view('admin.manage_partners', ['partnersData' => $partners, 'model' => $model, 'currentPage' => $currentPage]);
    }

    public function addPartner(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'partner_name' => 'required|string',
            ]);

            $partner_order = Partners::max('position_order');
            $position_order = ($partner_order !== null) ? $partner_order + 1 : 1;

            $partner = [
                'position_order' => $position_order,
                'partner_name' => $request->partner_name,
            ];

            if (!empty($request->file('partner_image'))) {
                $path = 'images/partners/';
                $filePath = $this->storeImage($request->file('partner_image'), $path);
                $partner['partner_image'] = $filePath;
            }

            if (Partners::create($partner)) {
                $request->session()->flash('success', 'Partner is inserted Successfully!');
                return redirect()->route('manage.partners');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.partner');
            }
        } else {
            $currentPage = "manage_partners";
            return view('admin.partner-ops', ['currentPage' => $currentPage]);
        }
    }

    public function editPartner(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'partner_name' => 'required|string',
            ]);

            $id = Crypt::decrypt($request->partner);
            $partner = Partners::findOrFail($id);
            $partner->partner_name = $request->partner_name;

            if (!empty($request->file('partner_image'))) {
                $path = 'images/partners/';
                $filePath = $this->storeImage($request->file("partner_image"), $path, $partner->partner_image);
                $partner->partner_image = $filePath;
            }

            if ($partner->save()) {
                $request->session()->flash('success', 'Partner is updated Successfully!');
                return redirect()->route('manage.partners');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.partner', $request->partner);
            }
        } else {
            $id = Crypt::decrypt($request->partner);
            $partner = Partners::where('id', $id)->firstOrFail();
            $partner->encrypted_id = $request->partner;
            $currentPage = "manage_partners";
            return view('admin.partner-ops', ["partner" => $partner, 'currentPage' => $currentPage]);
        }
    }
}
