<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\EducationalSessions;
use App\Models\Admin\Medium;
use App\Models\Admin\Types;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class DataInfoController extends Controller
{
    function manageTypes()
    {
        $types = Types::select('id', 'position_order', 'type_name', 'status')->orderBy('position_order')->get();
        foreach ($types as $type) {
            $type->encrypted_id = Crypt::encrypt($type->id);
        }

        $currentPage = "manage_types";
        $model = Crypt::encrypt('Types');
        return view('admin.manage_types', ['typesData' => $types, 'model' => $model, 'currentPage' => $currentPage]);
    }

    function manageMedium()
    {
        $languages = Medium::select('id', 'position_order', 'language_name', 'status')->orderBy('position_order')->get();
        foreach ($languages as $language) {
            $language->encrypted_id = Crypt::encrypt($language->id);
        }

        $currentPage = "manage_medium";
        $model = Crypt::encrypt('Medium');
        return view('admin.manage_medium', ['languagesData' => $languages, 'model' => $model, 'currentPage' => $currentPage]);
    }

    function manageSessions()
    {
        $sessions = EducationalSessions::select('id', 'position_order', 'session_name', 'status')->orderBy('position_order')->get();
        foreach ($sessions as $session) {
            $session->encrypted_id = Crypt::encrypt($session->id);
        }

        $currentPage = "manage_sessions";
        $model = Crypt::encrypt('EducationalSessions');
        return view('admin.manage_sessions', ['sessionsData' => $sessions, 'model' => $model, 'currentPage' => $currentPage]);
    }

    function addType(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'type_name' => 'required|string',
            ], [
                'type_name.required' => 'Please provide a Type Name.',
                'type_name.string' => 'Type Name must be a string.',
            ]);

            $order = Types::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $type = [
                'position_order' => $position_order,
                'type_name' => $request->type_name,
            ];

            if (Types::create($type)) {
                $request->session()->flash('success', 'Type is inserted Successfully!');
                return redirect()->route('manage.types');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.type');
            }
        } else {
            $currentPage = "manage_types";
            return view('admin.type-ops', ['currentPage' => $currentPage]);
        }
    }

    function addLanguage(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'language_name' => 'required|string',
            ], [
                'language_name.required' => 'Please provide a Name.',
                'language_name.string' => 'Name must be a string.',
            ]);

            $order = Medium::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $language = [
                'position_order' => $position_order,
                'language_name' => $request->language_name,
            ];

            if (Medium::create($language)) {
                $request->session()->flash('success', 'Language is inserted Successfully!');
                return redirect()->route('manage.medium');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.language');
            }
        } else {
            $currentPage = "manage_medium";
            return view('admin.language-ops', ['currentPage' => $currentPage]);
        }
    }

    function addSession(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'session_name' => 'required|string',
            ], [
                'session_name.required' => 'Please provide a Name.',
                'session_name.string' => 'Name must be a string.',
            ]);

            $order = EducationalSessions::max('position_order');
            $position_order = ($order !== null) ? $order + 1 : 1;

            $session = [
                'position_order' => $position_order,
                'session_name' => $request->session_name,
            ];

            if (EducationalSessions::create($session)) {
                $request->session()->flash('success', 'Session is inserted Successfully!');
                return redirect()->route('manage.sessions');
            } else {
                $request->session()->flash('error', 'Insertion Error!');
                return redirect()->route('add.session');
            }
        } else {
            $currentPage = "manage_sessions";
            return view('admin.session-ops', ['currentPage' => $currentPage]);
        }
    }

    function editType(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'type_name' => 'required|string',
            ], [
                'type_name.required' => 'Please provide a Type Name.',
                'type_name.string' => 'Type Name must be a string.',
            ]);

            $id = Crypt::decrypt($request->type);
            $type = Types::findOrFail($id);
            $type->type_name = $request->type_name;

            if ($type->save()) {
                $request->session()->flash('success', 'Type is updated Successfully!');
                return redirect()->route('manage.types');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.type', ["type" => $request->type]);
            }
        } else {
            $id = Crypt::decrypt($request->type);
            $type = Types::where('id', $id)->firstOrFail();
            $type->encrypted_id = $request->type;

            $currentPage = "manage_types";
            return view('admin.type-ops', ["type" => $type, 'currentPage' => $currentPage]);
        }
    }

    function editLanguage(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'language_name' => 'required|string',
            ], [
                'language_name.required' => 'Please provide a Name.',
                'language_name.string' => 'Name must be a string.',
            ]);

            $id = Crypt::decrypt($request->language);
            $language = Medium::findOrFail($id);
            $language->language_name = $request->language_name;

            if ($language->save()) {
                $request->session()->flash('success', 'Language is updated Successfully!');
                return redirect()->route('manage.medium');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.language', ["language" => $request->language]);
            }
        } else {
            $id = Crypt::decrypt($request->language);
            $language = Medium::where('id', $id)->firstOrFail();
            $language->encrypted_id = $request->language;

            $currentPage = "manage_medium";
            return view('admin.language-ops', ["language" => $language, 'currentPage' => $currentPage]);
        }
    }

    function editSession(Request $request)
    {
        if ($request->isMethod('post')) {
            $request->validate([
                'session_name' => 'required|string',
            ], [
                'session_name.required' => 'Please provide a Name.',
                'session_name.string' => 'Name must be a string.',
            ]);

            $id = Crypt::decrypt($request->session);
            $session = EducationalSessions::findOrFail($id);
            $session->session_name = $request->session_name;

            if ($session->save()) {
                $request->session()->flash('success', 'Session is updated Successfully!');
                return redirect()->route('manage.sessions');
            } else {
                $request->session()->flash('error', 'Updation Error!');
                return redirect()->route('edit.session', ["session" => $request->session]);
            }
        } else {
            $id = Crypt::decrypt($request->session);
            $session = EducationalSessions::where('id', $id)->firstOrFail();
            $session->encrypted_id = $request->session;

            $currentPage = "manage_sessions";
            return view('admin.session-ops', ["session" => $session, 'currentPage' => $currentPage]);
        }
    }
}
