<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;

class ActionsController extends Controller
{
    public function changeVisibility(Request $request)
    {
        $request->validate([
            'model' => 'required|string',
            'visibility' => 'required|string',
            'encrypted_id' => 'required|string',
        ]);

        $model_class = Crypt::decrypt($request->model);
        if ($model_class == 'Customers') {
            $modelClass = 'App\\Models\\' . Crypt::decrypt($request->model);
        } else {
            $modelClass = 'App\\Models\\Admin\\' . Crypt::decrypt($request->model);
        }

        if (!class_exists($modelClass)) {
            return response()->json(['status' => 'error', 'message' => "Can't find the table!"], 404);
        }

        $id = Crypt::decrypt($request->encrypted_id);
        $model = $modelClass::find($id);
        if (!$model) {
            return response()->json([
                'status' => 'error',
                'message' => "Can't find the data!",
            ], 404);
        }

        $model->visibility = $request->visibility;
        if ($model->save()) {
            return response()->json(['status' => 'done', 'message' => "Visibility is updated successfully."], 200);
        }

        return response()->json(['status' => 'error', 'message' => "Failed to update visibility!"], 500);
    }

    public function changeStatus(Request $request)
    {
        $request->validate([
            'model' => 'required|string',
            'encrypted_id' => 'required|string',
        ]);

        $model_class = Crypt::decrypt($request->model);
        if ($model_class == 'Customers') {
            $modelClass = 'App\\Models\\' . Crypt::decrypt($request->model);
        } else {
            $modelClass = 'App\\Models\\Admin\\' . Crypt::decrypt($request->model);
        }

        if (!class_exists($modelClass)) {
            return response()->json(['status' => 'error', 'message' => "Can't find the table!"], 404);
        }

        $id = Crypt::decrypt($request->encrypted_id);
        $model = $modelClass::find($id);
        if (!$model) {
            return response()->json([
                'status' => 'error',
                'message' => "Can't find the data!",
            ], 404);
        }

        $model->status = ($model->status == 'active' ? 'deactive' : 'active');
        if ($model->save()) {
            return response()->json(['status' => 'done', 'message' => "Status is updated successfully."], 200);
        }

        return response()->json(['status' => 'error', 'message' => "Failed to update Status!"], 500);
    }

    public function deleteItem(Request $request)
    {
        $request->validate([
            'model' => 'required|string',
            'encrypted_id' => 'required|string',
        ]);

        $model_class = Crypt::decrypt($request->model);
        if ($model_class == 'Customers') {
            $modelClass = 'App\\Models\\' . Crypt::decrypt($request->model);
        } else {
            $modelClass = 'App\\Models\\Admin\\' . Crypt::decrypt($request->model);
        }

        if (!class_exists($modelClass)) {
            return response()->json(['status' => 'error', 'message' => "Can't find the table!"], 404);
        }

        $id = Crypt::decrypt($request->encrypted_id);
        $model = $modelClass::find($id);
        if (!$model) {
            return response()->json([
                'status' => 'error',
                'message' => "Can't find the data!",
            ], 404);
        }

        if ($model->delete()) {
            return response()->json(['status' => 'done', 'title' => "Delete operation is done.", 'message' => "Your file has been deleted."], 200);
        }

        return response()->json(['status' => 'error', 'title' => "Failed to Delete!", 'message' => "Your data is safe :)"], 500);
    }
}
